/*
  ΥѴ (Unnormalized DCT-II):
      F[k]=_j=0^n-1 a[j]*cos(pi*(j+1/2)*k/n),0<=k<n 
  ׻.
  * ˡ
      B.G.Lee ˤʬ: 
      Cooley-Tukey  FFT: 
       2, ȿְ, Хե饤 1, in-place ¤ؤ
  * 
      n ϥǡ 2 .
*/
#include <math.h>

void fct_ii(int n, double a[])
{
    int m, mh, i, j, k, j0, j1;
    double theta, c2, xr;

    theta = 2 * atan(1.0) / n;
    /* ---- butterflies ---- */
    for (m = n; (mh = m >> 1) >= 1; m = mh) {
        for (i = 0; i < mh; i++) {
            c2 = 2 * cos(theta * (2 * i + 1));
            for (j = 0; j < n; j += m) {
                j0 = i + j;
                j1 = m - 1 - i + j;
                xr = a[j0] - a[j1];
                a[j0] += a[j1];
                a[j1] = c2 * xr;
            }
        }
        theta *= 2;
    }
    /* ---- scrambler ---- */
    i = 0;
    for (j = 1; j < n - 1; j++) {
        for (k = n >> 1; k > (i ^= k); k >>= 1);
        if (j < i) {
            xr = a[j];
            a[j] = a[i];
            a[i] = xr;
        }
    }
    /* ---- adds ---- */
    for (m = n >> 1; (mh = m >> 1) >= 1; m = mh) {
        for (j = 0; j < mh; j++) {
            j0 = m + mh + j;
            a[j0] = -a[j0] - a[j0 - m];
        }
        for (i = (m << 1) + mh; i < n; i += (m << 1)) {
            for (j = 0; j < mh; j++) {
                j0 = i + j;
                j1 = j0 + m;
                a[j0] -= a[j0 - m];
                a[j1] = -a[j1] - a[j0];
            }
        }
    }
    /* ---- scaling ---- */
    for (j = 1; j < n; j++) {
        a[j] *= 0.5;
    }
}

