/*
  ΥѴ (Unnormalized DCT-III): 
      a[k]=_j=0^n-1 F[j]*cos(pi*j*(k+1/2)/n),0<=k<n 
  ׻.
  * ˡ
      B.G.Lee ˤʬ: 
      Cooley-Tukey  FFT: 
       2, ְִ, Хե饤 1, in-place ¤ؤ
  * 
      n ϥǡ 2 .
*/
#include <math.h>

void fct_iii(int n, double a[])
{
    int m, mh, i, j, k, irev, j0, j1;
    double theta, c2, xr;

    /* ---- adds ---- */
    for (mh = 1; (m = mh << 1) < n; mh = m) {
        for (i = n - m - mh; i > mh; i -= (m << 1)) {
            for (j = 0; j < mh; j++) {
                j0 = i + j;
                j1 = j0 + m;
                a[j1] = -a[j1] - a[j0];
                a[j0] += a[j0 - m];
            }
        }
        for (j = 0; j < mh; j++) {
            j0 = m + mh + j;
            a[j0] = -a[j0] - a[j0 - m];
        }
    }
    theta = 2 * atan(1.0) / n;
    /* ---- butterflies ---- */
    for (m = n; (mh = m >> 1) >= 1; m = mh) {
        irev = 0;
        for (i = 0; i < n; i += m) {
            c2 = 1 / (2 * cos(theta * (irev + mh)));
            for (k = n >> 1; k > (irev ^= k); k >>= 1);
            for (j = 0; j < mh; j++) {
                j0 = i + j;
                j1 = n - mh - i + j;
                xr = c2 * a[j1];
                a[j1] = a[j0] - xr;
                a[j0] += xr;
            }
        }
    }
    /* ---- scrambler ---- */
    i = 0;
    for (j = 1; j < n - 1; j++) {
        for (k = n >> 1; k > (i ^= k); k >>= 1);
        if (j < i) {
            xr = a[j];
            a[j] = a[i];
            a[i] = xr;
        }
    }
}

