/*
  n x n 󼡸ʣ DFT :
      F[k1][k2]=_j1=0^n-1 _j2=0^n-1
                    a[j1][a2] * exp(2*pi*i*j1*k1/n)
                              * exp(2*pi*i*j2*k2/n)
  ׻. 
  * ˡ
      Vector-Radix FFT: 
      Cooley-Tukey  FFT: 
       2, ȿְ, Хե饤 1, in-place ¤ؤ
  * 
      n ϥǡ 2 , theta  2*pi/n .
*/
#include <math.h>

void fft2dr(int n, double theta, double **ar, double **ai)
{
    int m, mh, i1, i2, j1, j2, k1, k2;
    double w1r, w1i, w2r, w2i, w12r, w12i;
    double xr, xi, xjjr, xjji, xkjr, xkji, xjkr, xjki, xkkr, xkki;

    for (m = n; (mh = m >> 1) >= 1; m = mh) {
        for (i1 = 0; i1 < mh; i1++) {
            w1r = cos(theta * i1);
            w1i = sin(theta * i1);
            for (i2 = 0; i2 < mh; i2++) {
                w2r = cos(theta * i2);
                w2i = sin(theta * i2);
                w12r = cos(theta * (i1 + i2));
                w12i = sin(theta * (i1 + i2));
                for (j1 = i1; j1 < n; j1 += m) {
                    k1 = j1 + mh;
                    for (j2 = i2; j2 < n; j2 += m) {
                        k2 = j2 + mh;
                        xjjr = ar[j1][j2] + ar[k1][j2];
                        xjji = ai[j1][j2] + ai[k1][j2];
                        xkjr = ar[j1][j2] - ar[k1][j2];
                        xkji = ai[j1][j2] - ai[k1][j2];
                        xjkr = ar[j1][k2] + ar[k1][k2];
                        xjki = ai[j1][k2] + ai[k1][k2];
                        xkkr = ar[j1][k2] - ar[k1][k2];
                        xkki = ai[j1][k2] - ai[k1][k2];
                        ar[j1][j2] = xjjr + xjkr;
                        ai[j1][j2] = xjji + xjki;
                        xr = xjjr - xjkr;
                        xi = xjji - xjki;
                        ar[j1][k2] = w2r * xr - w2i * xi;
                        ai[j1][k2] = w2r * xi + w2i * xr;
                        xr = xkjr + xkkr;
                        xi = xkji + xkki;
                        ar[k1][j2] = w1r * xr - w1i * xi;
                        ai[k1][j2] = w1r * xi + w1i * xr;
                        xr = xkjr - xkkr;
                        xi = xkji - xkki;
                        ar[k1][k2] = w12r * xr - w12i * xi;
                        ai[k1][k2] = w12r * xi + w12i * xr;
                    }
                }
            }
        }
        theta *= 2;
    }
    /* ---- unscrambler ---- */
    i1 = 0;
    for (j1 = 1; j1 < n - 1; j1++) {
        for (k1 = n >> 1; k1 > (i1 ^= k1); k1 >>= 1);
        if (j1 < i1) {
            for (j2 = 0; j2 < n; j2++) {
                xr = ar[j1][j2];
                xi = ai[j1][j2];
                ar[j1][j2] = ar[i1][j2];
                ai[j1][j2] = ai[i1][j2];
                ar[i1][j2] = xr;
                ai[i1][j2] = xi;
            }
        }
    }
    for (j1 = 0; j1 < n; j1++) {
        i2 = 0;
        for (j2 = 1; j2 < n - 1; j2++) {
            for (k2 = n >> 1; k2 > (i2 ^= k2); k2 >>= 1);
            if (j2 < i2) {
                xr = ar[j1][j2];
                xi = ai[j1][j2];
                ar[j1][j2] = ar[j1][i2];
                ai[j1][j2] = ai[j1][i2];
                ar[j1][i2] = xr;
                ai[j1][i2] = xi;
            }
        }
    }
}

