/*
  ʣ DFT: 
      F[k]=_j=0^n-1 a[j]*exp(2*pi*i*j*k/n),0<=k<n 
  ׻.
  * ˡ
      Cooley-Tukey  FFT: 
       2, ȿְ, Хե饤 1,  in-place
  * 
      n ϥǡ 2 , theta  2*PI/n, 
      ar[0...n-1], ai[0...n-1], ϥǡμ, , 
      tmpr[0...n-1], tmpi[0...n-1] Ϻΰ.
*/
#include <math.h>

void fft(int n, double theta, double ar[], double ai[], 
        double tmpr[], double tmpi[])
{
    int nh, j;
    double xr, xi, wr, wi;

    if (n <= 1) return;
    nh = n / 2;
    for (j = 0; j < nh; j++) {
        tmpr[j] = ar[j] + ar[nh + j];
        tmpi[j] = ai[j] + ai[nh + j];
        xr = ar[j] - ar[nh + j];
        xi = ai[j] - ai[nh + j];
        wr = cos(theta * j);
        wi = sin(theta * j);
        tmpr[nh + j] = xr * wr - xi * wi;
        tmpi[nh + j] = xi * wr + xr * wi;
    }
    fft(nh, 2 * theta, tmpr, tmpi, ar, ai);
    fft(nh, 2 * theta, &tmpr[nh], &tmpi[nh], ar, ai);
    for (j = 0; j < nh; j++) {
        ar[2 * j] = tmpr[j];
        ai[2 * j] = tmpi[j];
        ar[2 * j + 1] = tmpr[nh + j];
        ai[2 * j + 1] = tmpi[nh + j];
    }
}

