/*
  ʣ DFT: 
      F[k]=_j=0^n-1 a[j]*exp(2*pi*i*j*k/n),0<=k<n 
  ׻.
  * ˡ
      Prime Factor  FFT: 
      PFA,  in-place
  * 
      n ϥǡǤ, theta  2*PI/n, 
      ar[0...n-1], ai[0...n-1], ϥǡμ, , 
      tmpr[0...n-1], tmpi[0...n-1] Ϻΰ.
*/
#include <math.h>

void fft(int n, double theta, double ar[], double ai[], 
        double tmpr[], double tmpi[])
{
    int n1, n2, j, j1, j2, k, k1, k2;
    double xr, xi, wr, wi;

    if (n <= 1) return;
    /* ---- factorization ---- */
    for (n1 = 2; n1 * n1 <= n; n1++) {
        if (n % n1 == 0) break;
    }
    if (n % n1 != 0) n1 = n;
    for (n2 = n; n2 % n1 == 0; n2 /= n1);
    n1 = n / n2;
    /* ---- short DFTs ---- */
    for (j2 = 0; j2 < n2; j2++) {
        for (k1 = 0; k1 < n1; k1++) {
            xr = ar[n1 * j2];
            xi = ai[n1 * j2];
            for (j1 = 1; j1 < n1; j1++) {
                j = (n1 * j2 + n2 * j1) % n;
                wr = cos(theta * n2 * j1 * k1);
                wi = sin(theta * n2 * j1 * k1);
                xr += wr * ar[j] - wi * ai[j];
                xi += wr * ai[j] + wi * ar[j];
            }
            tmpr[n2 * k1 + j2] = xr;
            tmpi[n2 * k1 + j2] = xi;
        }
    }
    for (j = 0; j < n; j += n2) {
        fft(n2, theta * n1, &tmpr[j], &tmpi[j], ar, ai);
    }
    /* ---- unscrambler ---- */
    for (k1 = 0; k1 < n1; k1++) {
        j1 = n2 * k1 % n1;
        for (k2 = 0; k2 < n2; k2++) {
            j2 = n1 * k2 % n2;
            k = (n2 * k1 + n1 * k2) % n;
            ar[k] = tmpr[n2 * j1 + j2];
            ai[k] = tmpi[n2 * j1 + j2];
        }
    }
}

