/*
  Υ Hartley Ѵ :
      F[k]=_j=0^n-1 a[j]*(cos(2*pi*j*k/n)+sin(2*pi*j*k/n)),0<=k<n
  ׻.
  * ˡ
      Cooley-Tukey  FFT: 
       2, ȿְ, Хե饤 2, in-place ¤ؤ
  * 
      n ϥǡ 2 .
*/
#include <math.h>

void fht(int n, double a[])
{
    int m, mh, mq, i, j, jr, ji, k, kr, ki;
    double theta, wr, wi, xr, xi;

    theta = 8 * atan(1.0) / n;
    for (m = n; (mh = m >> 1) >= 1; m = mh) {
        mq = mh >> 1;
        for (i = 0; i <= mq; i++) {
            /* ---- (cos + sin) == 1 ---- */
            if (i == 0 || i == mq) {
                for (jr = i; jr < n; jr += m) {
                    kr = jr + mh;
                    xr = a[jr] - a[kr];
                    a[jr] += a[kr];
                    a[kr] = xr;
                }
                continue;
            }
            /* ---- (cos + sin) != 1 ---- */
            wr = cos(theta * i);
            wi = sin(theta * i);
            for (j = 0; j < n; j += m) {
                jr = i + j;
                ji = mh - i + j;
                kr = jr + mh;
                ki = ji + mh;
                xr = a[jr] - a[kr];
                xi = a[ji] - a[ki];
                a[jr] += a[kr];
                a[ji] += a[ki];
                a[kr] = wr * xr + wi * xi;
                a[ki] = wi * xr - wr * xi;
            }
        }
        theta *= 2;
    }
    /* ---- unscrambler ---- */
    i = 0;
    for (j = 1; j < n - 1; j++) {
        for (k = n >> 1; k > (i ^= k); k >>= 1);
        if (j < i) {
            xr = a[j];
            a[j] = a[i];
            a[i] = xr;
        }
    }
}

