
/*
  Υ Hartley Ѵ :
      F[k]=_j=0^n-1 a[j]*(cos(2*pi*j*k/n)+sin(2*pi*j*k/n)),0<=k<n
  ׻.
  * ˡ
      Cooley-Tukey  FFT: 
      Split-Radix, ȿְ, Хե饤 2, in-place ¤ؤ
  * 
      n ϥǡ 2 .
*/
#include <math.h>

void fht(int n, double a[])
{
    int m, mq, mqh, i, j, k;
    int j0r, j0i, j1r, j1i, j2r, j2i, j3r, j3i;
    double theta, w1r, w1i, w3r, w3i, x0r, x0i, x1r, x1i, x3r, x3i;

    /* ---- L shaped butterflies ---- */
    theta = 8 * atan(1.0) / n;
    for (m = n; m > 4; m >>= 1) {
        mq = m >> 2;
        mqh = mq >> 1;
        /* ---- (cos + sin) == sqrt(2) ---- */
        w1r = 2 * cos(theta * mqh);
        for (k = m; k <= n; k <<= 2) {
            for (j0r = k - m; j0r < n; j0r += 2 * k) {
                j1r = j0r + mqh;
                j0i = j0r + mq;
                j1i = j1r + mq;
                j2r = j0i + mq;
                j3r = j1i + mq;
                j2i = j2r + mq;
                j3i = j3r + mq;
                x1r = a[j0r] - a[j2r];
                x1i = a[j0i] - a[j2i];
                a[j0r] += a[j2r];
                a[j0i] += a[j2i];
                a[j2r] = x1r + x1i;
                a[j2i] = x1r - x1i;
                x3r = w1r * (a[j1r] - a[j3r]);
                x3i = w1r * (a[j1i] - a[j3i]);
                a[j1r] += a[j3r];
                a[j1i] += a[j3i];
                a[j3r] = x3r;
                a[j3i] = x3i;
            }
        }
        for (i = 1; i < mqh; i++) {
            /* ---- (cos + sin) != sqrt(2) ---- */
            w1r = cos(theta * i);
            w1i = sin(theta * i);
            w3r = cos(theta * 3 * i);
            w3i = sin(theta * 3 * i);
            for (k = m; k <= n; k <<= 2) {
                for (j = k - m; j < n; j += 2 * k) {
                    j0r = i + j;
                    j1r = mq - i + j;
                    j0i = j1r + mq;
                    j1i = j0r + mq;
                    j2r = j1i + mq;
                    j3r = j0i + mq;
                    j2i = j3r + mq;
                    j3i = j2r + mq;
                    x1r = a[j0r] - a[j2r];
                    x1i = a[j0i] - a[j2i];
                    a[j0r] += a[j2r];
                    a[j0i] += a[j2i];
                    x3r = a[j1r] - a[j3r];
                    x3i = a[j1i] - a[j3i];
                    a[j1r] += a[j3r];
                    a[j1i] += a[j3i];
                    x0r = x1r + x3r;
                    x0i = x1i - x3i;
                    a[j2r] = w1r * x0r + w1i * x0i;
                    a[j3r] = w1i * x0r - w1r * x0i;
                    x0r = x1r - x3r;
                    x0i = x1i + x3i;
                    a[j3i] = w3r * x0r + w3i * x0i;
                    a[j2i] = w3i * x0r - w3r * x0i;
                }
            }
        }
        theta *= 2;
    }
    /* ---- radix 2 butterflies (m == 4) ---- */
    for (k = 4; k <= n; k <<= 2) {
        for (j = k - 4; j < n; j += 2 * k) {
            x0r = a[j] - a[j + 2];
            x0i = a[j + 1] - a[j + 3];
            a[j] += a[j + 2];
            a[j + 1] += a[j + 3];
            a[j + 2] = x0r;
            a[j + 3] = x0i;
        }
    }
    /* ---- radix 2 butterflies (last stage) ---- */
    if (n > 1) {
        for (j = 0; j < n; j += 2) {
            x0r = a[j] - a[j + 1];
            a[j] += a[j + 1];
            a[j + 1] = x0r;
        }
    }
    /* ---- unscrambler ---- */
    i = 0;
    for (j = 1; j < n - 1; j++) {
        for (k = n >> 1; k > (i ^= k); k >>= 1);
        if (j < i) {
            x0r = a[j];
            a[j] = a[i];
            a[i] = x0r;
        }
    }
}

