/*
  ΥѴ (Unnormalized DST-III): 
      a[k]=_j=1^n F[j]*sin(pi*j*(k+1/2)/n),0<=k<n 
  ׻.
  * ˡ
      Ĺ黻κ: 
      Cooley-Tukey  FFT: 
       2, ְִ, Хե饤 1, in-place ¤ؤ
  * 
      n ϥǡ 2 , 
      Ϥ F[n] = a[0], F[k] = a[k], 0<k<n Ȥ.
*/
#include <math.h>

void fst_iii(int n, double a[])
{
    int m, mh, mq, i, j, k, irev, jr, ji, kr, ki;
    double theta, wr, wi, xr, xi;

    theta = 4 * atan(1.0) / n;
    if (n > 1) {
        m = n >> 1;
        xr = a[m] * cos(0.5 * theta * m);
        a[m] = xr - a[0];
        a[0] += xr;
    }
    for (m = n; (mh = m >> 1) >= 2; m = mh) {
        mq = mh >> 1;
        /* ---- real & complex to real butterflies ---- */
        irev = 0;
        for (jr = 0; jr < n; jr += m) {
            wr = cos(0.5 * theta * (irev + mq));
            wi = sin(0.5 * theta * (irev + mq));
            for (k = n >> 2; k > (irev ^= k); k >>= 1);
            ki = jr + mq;
            kr = n - ki;
            ji = kr - mq;
            xr = wr * a[kr] + wi * a[ki];
            xi = wr * a[ki] - wi * a[kr];
            a[kr] = xr - a[jr];
            a[ki] = xi - a[ji];
            a[jr] += xr;
            a[ji] += xi;
        }
        if (mh == 2) continue;
        /* ---- complex to complex butterflies ---- */
        irev = 0;
        for (i = 0; i < n; i += m) {
            wr = cos(theta * (irev + mq));
            wi = sin(theta * (irev + mq));
            for (k = n >> 2; k > (irev ^= k); k >>= 1);
            for (j = 1; j < mq; j++) {
                ji = i + j;
                kr = i + mh - j;
                jr = n - ji;
                ki = n - kr;
                xr = wr * a[ki] + wi * a[kr];
                xi = wr * a[kr] - wi * a[ki];
                a[kr] = xr - a[jr];
                a[ki] = xi + a[ji];
                a[jr] += xr;
                a[ji] -= xi;
            }
        }
    }
    /* ---- scrambler ---- */
    i = 0;
    for (j = 1; j < n - 1; j++) {
        for (k = n >> 1; k > (i ^= k); k >>= 1);
        if (j < i) {
            xr = a[j];
            a[j] = a[i];
            a[i] = xr;
        }
    }
}

