/*
  ʣǻ֥եȳĥ DFT: 
      F[k]=_j=0^n-1 a[j]*exp(2*pi*i*(j+delta1)*k/n),0<=k<n 
  ׻.
  * ˡ
      Cooley-Tukey  FFT: 
       2, ȿְ, Хե饤 1, in-place ¤ؤ
  * 
      n ϥǡ 2 , theta  2*PI/n, 
      ar[0...n-1], ai[0...n-1], ϥǡμ, .
*/
#include <math.h>

void gfft1(int n, double theta, double delta1, double ar[], double ai[])
{
    int m, mh, i, j, k;
    double wr, wi, xr, xi;

    for (m = n; (mh = m >> 1) >= 1; m = mh) {
        for (i = 0; i < mh; i++) {
            wr = cos(theta * (i + delta1));
            wi = sin(theta * (i + delta1));
            for (j = i; j < n; j += m) {
                k = j + mh;
                xr = ar[j] - ar[k];
                xi = ai[j] - ai[k];
                ar[j] += ar[k];
                ai[j] += ai[k];
                ar[k] = wr * xr - wi * xi;
                ai[k] = wr * xi + wi * xr;
            }
        }
        theta *= 2;
    }
    /* ---- unscrambler ---- */
    i = 0;
    for (j = 1; j < n - 1; j++) {
        for (k = n >> 1; k > (i ^= k); k >>= 1);
        if (j < i) {
            xr = ar[j];
            xi = ai[j];
            ar[j] = ar[i];
            ai[j] = ai[i];
            ar[i] = xr;
            ai[i] = xi;
        }
    }
}

