/*
  ¿ǡ DFT εѴ: 
      F[k] = (a[0]+a[n/2]*(-1)^k)/2
                 + _j=1^n/2-1 a[j]*cos(2*pi*j*k/n)
                 + _j=1^n/2-1 a[n-j]*sin(2*pi*j*k/n)
  ׻.
  : 󥰤 2/n ʤФʤ
  * ˡ
      Cooley-Tukey  FFT: 
       2, ȿְ, Хե饤 2, in-place ¤ؤ
  * 
      n ϥǡ 2 .
*/
#include <math.h>

void irfft(int n, double a[])
{
    int m, mh, mq, i, j, k, jr, ji, kr, ki;
    double theta, wr, wi, xr, xi;

    a[0] *= 0.5;
    a[n/2] *= 0.5;
    theta = 8 * atan(1.0) / n;  /* 2*pi/n */
    for (m = n; (mh = m >> 1) >= 1; m = mh) {
        mq = mh >> 1;
        /* ---- real to real butterflies (W == 1) ---- */
        for (jr = 0; jr < n; jr += m) {
            kr = jr + mh;
            xr = a[jr] - a[kr];
            a[jr] += a[kr];
            a[kr] = xr;
        }
        /* ---- complex to complex butterflies (W != 1) ---- */
        for (i = 1; i < mq; i++) {
            wr = cos(theta * i);
            wi = sin(theta * i);
            for (j = 0; j < n; j += m) {
                jr = j + i;
                ji = j + mh - i;
                kr = j + mh + i;
                ki = j + m - i;
                xr = a[jr] - a[ji];
                xi = a[ki] + a[kr];
                a[jr] = a[jr] + a[ji];
                a[ji] = a[ki] - a[kr];
                a[kr] = wr * xr + wi * xi;
                a[ki] = wr * xi - wi * xr;
            }
        }
        /* ---- complex to real butterflies are trivial ---- */
        theta *= 2;
    }
    /* ---- unscrambler ---- */
    i = 0;
    for (j = 1; j < n - 1; j++) {
        for (k = n >> 1; k > (i ^= k); k >>= 1);
        if (j < i) {
            xr = a[j];
            a[j] = a[i];
            a[i] = xr;
        }
    }
}

