/* ® Hartley ѴŪѤƼ¿ FFT ׻ */

/*
  ¿ǡ DFT :
  F[k]=_j=0^n-1 a[j]*exp(-2*pi*i*j*k/n),0<=k<n ׻.
   a[0...n/2], a[n/2+1...n-1] Ϥ줾 F[0...n/2] μ, 
  F[n/2+1...n-1] ε롥
*/

void rfft(int n, double a[])
{
    void fht(int n, double a[]);
    int nh, j;
    double x;

    fht(n, a);
    nh = n / 2;
    for (j = 1; j < nh; j++) {
        x = 0.5 * (a[j] - a[n - j]);
        a[j] -= x;
        a[n - j] = x;
    }
}


/*
  ¿ǡ DFT εѴ:
  F[k] = (a[0]+a[n/2]*(-1)^k)/2 + _j=1^n/2-1 a[j]*cos(2*pi*j*k/n)
                                + _j=1^n/2-1 a[n-j]*sin(2*pi*j*k/n)
  ׻. 
  : 󥰤 2/n ʤФʤ
*/

void irfft(int n, double a[])
{
    void fht(int n, double a[]);
    int nh, j;
    double x;

    nh = n / 2;
    a[0] *= 0.5;
    a[nh] *= 0.5;
    for (j = 1; j < nh; j++) {
        x = 0.5 * (a[j] - a[n - j]);
        a[j] -= x;
        a[n - j] = x;
    }
    fht(n, a);
}

