/*
  ΥѴ (Unnormalized DCT-II):
      F[k]=_j=0^n-1 a[j]*cos(pi*(j+1/2)*k/n),0<=k<n 
  ׻.
  * ˡ
       1/4 եȳĥ DFT Ѥ:
      rfft() ƤӽФ 1/4 եȤ.
  * 
      n ϥǡ 2 .
*/
#include <math.h>

void fct_ii(int n, double a[], double tmp[])
{
    void rfft(int n, double a[]);
    int nh, j, k;
    double theta, wr, wi, xr, xi;

    nh = n / 2;
    for (j = 0; j < nh; j++) {
        tmp[j] = a[2 * j];
        tmp[n - 1 - j] = a[2 * j + 1];
    }
    /* ---- 1/4 Shifted DFT ---- */
    rfft(n, tmp);
    theta = 2 * atan(1.0) / n;  /* 2*pi/(4*n) */
    for (k = 1; k < nh; k++) {
        wr = cos(theta * k);
        wi = sin(theta * k);
        xr = tmp[k];
        xi = tmp[n - k];
        a[k] = wr * xr - wi * xi;
        a[n - k] = wr * xi + wi * xr;
    }
    a[0] = tmp[0];
    a[nh] = tmp[nh] * cos(theta * nh);
}

