/*
  ΥѴ (Unnormalized DCT-III): 
      a[k]=_j=0^n-1 F[j]*cos(pi*j*(k+1/2)/n),0<=k<n 
  ׻롥
  * ˡ
      ȿ 1/4 եȳĥ DFT Ѥ:
      ȿ 1/4 եȤ, irfft() ƤӽФ.
  * 
      n ϥǡ 2 .
*/
#include <math.h>

void fct_iii(int n, double a[], double tmp[])
{
    void irfft(int n, double a[]);
    int nh, j, k;
    double theta, wr, wi, xr, xi;

    nh = n / 2;
    theta = -2 * atan(1.0) / n;  /* 2*pi/(4*n) */
    for (k = 1; k < nh; k++) {
        wr = cos(theta * k);
        wi = sin(theta * k);
        xr = a[k];
        xi = a[n - k];
        tmp[k] = wr * xr - wi * xi;
        tmp[n - k] = wr * xi + wi * xr;
    }
    tmp[0] = a[0] * 2;
    tmp[nh] = a[nh] * 2 * cos(theta * nh);
    irfft(n, tmp);
    for (j = 0; j < nh; j++) {
        a[2 * j] = tmp[j];
        a[2 * j + 1] = tmp[n - 1 - j];
    }
}

