/*
  ΥѴ (Unnormalized DCT-II):
      F[k]=_j=0^n-1 a[j]*cos(pi*(j+1/2)*k/n),0<=k<n 
  ׻.
  * ˡ
      Ĺ黻κ: 
      Cooley-Tukey  FFT: 
       2, ȿְ, Хե饤 1, in-place ¤ؤ
  * 
      n ϥǡ 2 .
*/
#include <math.h>

void fct_ii(int n, double a[])
{
    int m, mh, mq, i, j, k, irev, jr, ji, kr, ki;
    double theta, wr, wi, xr, xi;

    /* ---- scrambler ---- */
    i = 0;
    for (j = 1; j < n - 1; j++) {
        for (k = n >> 1; k > (i ^= k); k >>= 1);
        if (j < i) {
            xr = a[j];
            a[j] = a[i];
            a[i] = xr;
        }
    }
    theta = -4 * atan(1.0) / n;
    for (mh = 2; (m = mh << 1) <= n; mh = m) {
        mq = mh >> 1;
        /* ---- real to real & complex butterflies ---- */
        irev = 0;
        for (jr = 0; jr < n; jr += m) {
            wr = cos(0.5 * theta * (irev + mq));
            wi = sin(0.5 * theta * (irev + mq));
            for (k = n >> 2; k > (irev ^= k); k >>= 1);
            ki = jr + mq;
            kr = n - ki;
            ji = kr - mq;
            xr = a[jr] - a[kr];
            xi = -a[ji] + a[ki];
            a[jr] += a[kr];
            a[ji] += a[ki];
            a[ki] = wr * xr + wi * xi;
            a[kr] = wr * xi - wi * xr;
        }
        if (mh == 2) continue;
        /* ---- complex to complex butterflies ---- */
        irev = 0;
        for (i = 0; i < n; i += m) {
            wr = cos(theta * (irev + mq));
            wi = sin(theta * (irev + mq));
            for (k = n >> 2; k > (irev ^= k); k >>= 1);
            for (j = 1; j < mq; j++) {
                jr = i + j;
                ki = i + mh - j;
                ji = n - jr;
                kr = n - ki;
                xr = a[jr] - a[kr];
                xi = -a[ji] - a[ki];
                a[jr] += a[kr];
                a[ji] -= a[ki];
                a[ki] = wr * xr + wi * xi;
                a[kr] = wr * xi - wi * xr;
            }
        }
    }
    if (n > 1) {
        m = n >> 1;
        xr = a[0] - a[m];
        a[0] += a[m];
        a[m] = xr * cos(0.5 * theta * m);
    }
}

