/*
  ΥѴ (Unnormalized DCT-III): 
      a[k]=_j=0^n-1 F[j]*cos(pi*j*(k+1/2)/n),0<=k<n 
  ׻.
  * ˡ
      B.G.Lee ˤʬ: 
      Cooley-Tukey  FFT: 
       2, ְִ, Хե饤 1, in-place ¤ؤ
  * 
      n ϥǡ 2 .
*/
#include <math.h>

void fct_iii(int n, double a[])
{
    int m, mh, i, j, k, j0, j1;
    double theta, c2, xr;

    /* ---- adds ---- */
    for (mh = 1; (m = mh << 1) < n; mh = m) {
        for (i = n - m - mh; i > mh; i -= (m << 1)) {
            for (j = 0; j < mh; j++) {
                j0 = i + j;
                j1 = j0 + m;
                a[j1] = -a[j1] - a[j0];
                a[j0] += a[j0 - m];
            }
        }
        for (j = 0; j < mh; j++) {
            j0 = m + mh + j;
            a[j0] = -a[j0] - a[j0 - m];
        }
    }
    /* ---- scrambler ---- */
    i = 0;
    for (j = 1; j < n - 1; j++) {
        for (k = n >> 1; k > (i ^= k); k >>= 1);
        if (j < i) {
            xr = a[j];
            a[j] = a[i];
            a[i] = xr;
        }
    }
    theta = 2 * atan(1.0);
    /* ---- butterflies ---- */
    for (mh = 1; (m = mh << 1) <= n; mh = m) {
        theta *= 0.5;
        for (i = 0; i < mh; i++) {
            c2 = 1 / (2 * cos(theta * (2 * i + 1)));
            for (j = 0; j < n; j += m) {
                j0 = i + j;
                j1 = m - 1 - i + j;
                xr = c2 * a[j1];
                a[j1] = a[j0] - xr;
                a[j0] += xr;
            }
        }
    }
}

