/*
  ΥѴ (Unnormalized DCT-III): 
      a[k]=_j=0^n-1 F[j]*cos(pi*j*(k+1/2)/n),0<=k<n 
  ׻.
  * ˡ
      Ĺ黻κ: 
      Cooley-Tukey  FFT: 
       2, ְִ, Хե饤 1, in-place ¤ؤ
  * 
      n ϥǡ 2 .
*/
#include <math.h>

void fct_iii(int n, double a[])
{
    int m, mh, mq, i, j, k, irev, jr, ji, kr, ki;
    double theta, wr, wi, xr, xi;

    theta = 4 * atan(1.0) / n;
    if (n > 1) {
        m = n >> 1;
        xr = a[m] * cos(0.5 * theta * m);
        a[m] = a[0] - xr;
        a[0] += xr;
    }
    for (m = n; (mh = m >> 1) >= 2; m = mh) {
        mq = mh >> 1;
        /* ---- real & complex to real butterflies ---- */
        irev = 0;
        for (jr = 0; jr < n; jr += m) {
            wr = cos(0.5 * theta * (irev + mq));
            wi = sin(0.5 * theta * (irev + mq));
            for (k = n >> 2; k > (irev ^= k); k >>= 1);
            ki = jr + mq;
            kr = n - ki;
            ji = kr - mq;
            xr = wr * a[ki] + wi * a[kr];
            xi = wr * a[kr] - wi * a[ki];
            a[kr] = a[jr] - xr;
            a[ki] = a[ji] + xi;
            a[jr] += xr;
            a[ji] -= xi;
        }
        if (mh == 2) continue;
        /* ---- complex to complex butterflies ---- */
        irev = 0;
        for (i = 0; i < n; i += m) {
            wr = cos(theta * (irev + mq));
            wi = sin(theta * (irev + mq));
            for (k = n >> 2; k > (irev ^= k); k >>= 1);
            for (j = 1; j < mq; j++) {
                jr = i + j;
                ki = i + mh - j;
                ji = n - jr;
                kr = n - ki;
                xr = wr * a[ki] + wi * a[kr];
                xi = wr * a[kr] - wi * a[ki];
                a[kr] = a[jr] - xr;
                a[ki] = -a[ji] - xi;
                a[jr] += xr;
                a[ji] -= xi;
            }
        }
    }
    /* ---- unscrambler ---- */
    i = 0;
    for (j = 1; j < n - 1; j++) {
        for (k = n >> 1; k > (i ^= k); k >>= 1);
        if (j < i) {
            xr = a[j];
            a[j] = a[i];
            a[i] = xr;
        }
    }
}

