/*
  n1 x n2 󼡸ʣ DFT :
      F[k1][k2]=_j1=0^n1-1 _j2=0^n2-1
                    a[j1][a2] * exp(2*pi*i*j1*k1/n1)
                              * exp(2*pi*i*j2*k2/n2)
  ׻. 
  * ˡ
      Row-Column ˡ:
      fft() (켡 FFT) ƤӽФ, ž֤ʤ
  * 
      n1, n2 ϥǡ 2 , flag ϻؿ 1, 
      tmpr[0...n1-1], tmpi[0...n1-1] Ϻΰ.
*/
#include <math.h>

void fft2d(int n1, int n2, int flag, double **ar, double **ai, 
        double tmpr[], double tmpi[])
{
    void fft(int n, double theta, double ar[], double ai[]);
    int j1, j2;
    double pi;

    pi = 4 * atan(1.0);
    /* ---- FFT of the rows ---- */
    for (j1 = 0; j1 < n1; j1++) {
        fft(n2, flag * 2 * pi / n2, ar[j1], ai[j1]);
    }
    /* ---- FFT of the columns ---- */
    for (j2 = 0; j2 < n2; j2++) {
        for (j1 = 0; j1 < n1; j1++) {
            tmpr[j1] = ar[j1][j2];
            tmpi[j1] = ai[j1][j2];
        }
        fft(n1, flag * 2 * pi / n1, tmpr, tmpi);
        for (j1 = 0; j1 < n1; j1++) {
            ar[j1][j2] = tmpr[j1];
            ai[j1][j2] = tmpi[j1];
        }
    }
}

