/*
  ʣ DFT: 
      F[k]=_j=0^n-1 a[j]*exp(2*pi*i*j*k/n),0<=k<n 
  ׻.
  * ˡ
      Cooley-Tukey  FFT: 
      , ȿְ, Хե饤 1,  in-place
  * 
      n ϥǡǤ, theta  2*PI/n, 
      ar[0...n-1], ai[0...n-1], ϥǡμ, , 
      tmpr[0...n-1], tmpi[0...n-1] Ϻΰ.
*/
#include <math.h>

void fft(int n, double theta, double ar[], double ai[], 
        double tmpr[], double tmpi[])
{
    int radix, n_radix, j, m, r;
    double xr, xi, wr, wi;

    if (n <= 1) return;
    /* ---- factorization ---- */
    for (radix = 2; radix * radix <= n; radix++) {
        if (n % radix == 0) break;
    }
    if (n % radix != 0) radix = n;
    n_radix = n / radix;
    /* ---- butterflies ---- */
    for (j = 0; j < n_radix; j++) {
        for (m = 0; m < radix; m++) {
            xr = ar[j];
            xi = ai[j];
            for (r = n_radix; r < n; r += n_radix) {
                wr = cos(theta * m * r);
                wi = sin(theta * m * r);
                xr += wr * ar[r + j] - wi * ai[r + j];
                xi += wr * ai[r + j] + wi * ar[r + j];
            }
            wr = cos(theta * m * j);
            wi = sin(theta * m * j);
            tmpr[m * n_radix + j] = xr * wr - xi * wi;
            tmpi[m * n_radix + j] = xi * wr + xr * wi;
        }
    }
    for (r = 0; r < n; r += n_radix) {
        fft(n_radix, theta * radix, &tmpr[r], &tmpi[r], ar, ai);
    }
    for (j = 0; j < n_radix; j++) {
        for (m = 0; m < radix; m++) {
            ar[radix * j + m] = tmpr[n_radix * m + j];
            ai[radix * j + m] = tmpi[n_radix * m + j];
        }
    }
}

