/*
  ʣ DFT: 
      F[k]=_j=0^n-1 a[j]*exp(-2*pi*i*j*k/n),0<=k<n 
  ׻.
  * ˡ
      Cooley-Tukey  FFT: 
      Split-Radix, ȿְ, Хե饤 1, in-place ¤ؤ
  * 
      n ϥǡ 2 , 
      ar[0...n-1], ai[0...n-1], ϥǡμ, .
*/
#include <math.h>

void fft(int n, double ar[], double ai[])
{
    int m, mq, i, j, j1, j2, j3, k;
    double theta, w1r, w1i, w3r, w3i;
    double x0r, x0i, x1r, x1i, x3r, x3i;
    
    /* ---- L shaped butterflies ---- */
    theta = -8 * atan(1.0) / n;
    for (m = n; m > 2; m >>= 1) {
        mq = m >> 2;
        for (i = 0; i < mq; i++) {
            w1r = cos(theta * i);
            w1i = sin(theta * i);
            w3r = cos(theta * 3 * i);
            w3i = sin(theta * 3 * i);
            for (k = m; k <= n; k <<= 2) {
                for (j = k - m + i; j < n; j += 2 * k) {
                    j1 = j + mq;
                    j2 = j1 + mq;
                    j3 = j2 + mq;
                    x1r = ar[j] - ar[j2];
                    x1i = ai[j] - ai[j2];
                    ar[j] += ar[j2];
                    ai[j] += ai[j2];
                    x3r = ar[j3] - ar[j1];
                    x3i = ai[j3] - ai[j1];
                    ar[j1] += ar[j3];
                    ai[j1] += ai[j3];
                    x0r = x1r - x3i;
                    x0i = x1i + x3r;
                    ar[j2] = w1r * x0r - w1i * x0i;
                    ai[j2] = w1r * x0i + w1i * x0r;
                    x0r = x1r + x3i;
                    x0i = x1i - x3r;
                    ar[j3] = w3r * x0r - w3i * x0i;
                    ai[j3] = w3r * x0i + w3i * x0r;
                }
            }
        }
        theta *= 2;
    }
    /* ---- radix 2 butterflies ---- */
    for (k = 2; k <= n; k <<= 2) {
        for (j = k - 2; j < n; j += 2 * k) {
            x0r = ar[j] - ar[j + 1];
            x0i = ai[j] - ai[j + 1];
            ar[j] += ar[j + 1];
            ai[j] += ai[j + 1];
            ar[j + 1] = x0r;
            ai[j + 1] = x0i;
        }
    }
    /* ---- unscrambler ---- */
    i = 0;
    for (j = 1; j < n - 1; j++) {
        for (k = n >> 1; k > (i ^= k); k >>= 1);
        if (j < i) {
            x0r = ar[j];
            x0i = ai[j];
            ar[j] = ar[i];
            ai[j] = ai[i];
            ar[i] = x0r;
            ai[i] = x0i;
        }
    }
}

