/*
  ʣ DFT: 
      F[k]=_j=0^n-1 a[j]*exp(-2*pi*i*j*k/n),0<=k<n 
  ׻.
  * ˡ
      Cooley-Tukey  FFT: 
      Split-Radix, ȿְ, Хե饤 3, in-place ¤ؤ
  * 
      n ϥǡ 2 , 
      ar[0...n-1], ai[0...n-1], ϥǡμ, .
*/
#include <math.h>

void fft(int n, double ar[], double ai[])
{
    int m, mq, irev, i, j, j1, j2, j3, k;
    double theta, w1r, w1i, w3r, w3i;
    double x0r, x0i, x1r, x1i, x3r, x3i;
    
    /* ---- scrambler ---- */
    i = 0;
    for (j = 1; j < n - 1; j++) {
        for (k = n >> 1; k > (i ^= k); k >>= 1);
        if (j < i) {
            x0r = ar[j];
            x0i = ai[j];
            ar[j] = ar[i];
            ai[j] = ai[i];
            ar[i] = x0r;
            ai[i] = x0i;
        }
    }
    /* ---- L shaped butterflies ---- */
    theta = -2 * atan(1.0) / n;
    for (m = 4; m <= n; m <<= 1) {
        mq = m >> 2;
        /* ---- W == 1 ---- */
        for (k = mq; k >= 1; k >>= 2) {
            for (j = mq - k; j < mq - (k >> 1); j++) {
                j1 = j + mq;
                j2 = j1 + mq;
                j3 = j2 + mq;
                x1r = ar[j] - ar[j1];
                x1i = ai[j] - ai[j1];
                ar[j] += ar[j1];
                ai[j] += ai[j1];
                x3r = ar[j3] - ar[j2];
                x3i = ai[j3] - ai[j2];
                ar[j2] += ar[j3];
                ai[j2] += ai[j3];
                ar[j1] = x1r - x3i;
                ai[j1] = x1i + x3r;
                ar[j3] = x1r + x3i;
                ai[j3] = x1i - x3r;
            }
        }
        if (m == n) continue;
        /* ---- W == exp(-pi*i/4) ---- */
        irev = n >> 1;
        w1r = cos(theta * irev);
        for (k = mq; k >= 1; k >>= 2) {
            for (j = m + mq - k; j < m + mq - (k >> 1); j++) {
                j1 = j + mq;
                j2 = j1 + mq;
                j3 = j2 + mq;
                x1r = ar[j] - ar[j1];
                x1i = ai[j] - ai[j1];
                ar[j] += ar[j1];
                ai[j] += ai[j1];
                x3r = ar[j3] - ar[j2];
                x3i = ai[j3] - ai[j2];
                ar[j2] += ar[j3];
                ai[j2] += ai[j3];
                x0r = x1r - x3i;
                x0i = x1i + x3r;
                ar[j1] = w1r * (x0r + x0i);
                ai[j1] = w1r * (x0i - x0r);
                x0r = x1r + x3i;
                x0i = x1i - x3r;
                ar[j3] = w1r * (-x0r + x0i);
                ai[j3] = w1r * (-x0i - x0r);
            }
        }
        /* ---- W != 1, exp(-pi*i/4) ---- */
        for (i = 2 * m; i < n; i += m) {
            for (k = n >> 1; k > (irev ^= k); k >>= 1);
            w1r = cos(theta * irev);
            w1i = sin(theta * irev);
            w3r = cos(theta * 3 * irev);
            w3i = sin(theta * 3 * irev);
            for (k = mq; k >= 1; k >>= 2) {
                for (j = i + mq - k; j < i + mq - (k >> 1); j++) {
                    j1 = j + mq;
                    j2 = j1 + mq;
                    j3 = j2 + mq;
                    x1r = ar[j] - ar[j1];
                    x1i = ai[j] - ai[j1];
                    ar[j] += ar[j1];
                    ai[j] += ai[j1];
                    x3r = ar[j3] - ar[j2];
                    x3i = ai[j3] - ai[j2];
                    ar[j2] += ar[j3];
                    ai[j2] += ai[j3];
                    x0r = x1r - x3i;
                    x0i = x1i + x3r;
                    ar[j1] = w1r * x0r - w1i * x0i;
                    ai[j1] = w1r * x0i + w1i * x0r;
                    x0r = x1r + x3i;
                    x0i = x1i - x3r;
                    ar[j3] = w3r * x0r - w3i * x0i;
                    ai[j3] = w3r * x0i + w3i * x0r;
                }
            }
        }
    }
    /* ---- radix 2 butterflies ---- */
    mq = n >> 1;
    for (k = mq; k >= 1; k >>= 2) {
        for (j = mq - k; j < mq - (k >> 1); j++) {
            j1 = mq + j;
            x0r = ar[j] - ar[j1];
            x0i = ai[j] - ai[j1];
            ar[j] += ar[j1];
            ai[j] += ai[j1];
            ar[j1] = x0r;
            ai[j1] = x0i;
        }
    }
}

