/*
  ʣ DFT: 
      F[k]=_j=0^n-1 a[j]*exp(-2*pi*i*j*k/n),0<=k<n 
  ׻.
  * ˡ
      Prime Factor  FFT: 
      ̤ DFT Ѥ PFA, 󥻥ե, in-place ¤ؤ
  * 
      n ϥǡǡ
      n = 2^m2 * 3^m3 * 5^m5, 0<=m2<=2, 0<=m3<=1, 0<=m5<=1
      ʤФʤʤ
      ar[0...n-1], ai[0...n-1], ϥǡμ, , 
      br[0...n-1], bi[0...n-1], Ͻϥǡμ, , 
      ϥǡݻ.
*/
#include <math.h>

#define NFACTOR 4

void length2dft(int n, int n2, int n2t2, double ar[], double ai[]);
void length3dft(int n, int n2, int n2t2, double ar[], double ai[]);
void length4dft(int n, int n2, int n2t2, double ar[], double ai[]);
void length5dft(int n, int n2, int n2t2, double ar[], double ai[]);

void fft(int n, double ar[], double ai[], double br[], double bi[])
{
    static int factor[NFACTOR] = {5, 4, 3, 2};
    int ndiv, mtbl, n1tbl[NFACTOR], n2tbl[NFACTOR];
    int n1, n2, n2sum, n2t2, m, j, k;

    /* ---- factorization ---- */
    ndiv = n;
    mtbl = 0;
    for (m = 0; m < NFACTOR; m++) {
        n1 = factor[m];
        if (ndiv % n1 != 0) continue;
        ndiv /= n1;
        n2 = n / n1;
        n1tbl[mtbl] = n1;
        n2tbl[mtbl++] = n2;
    }
    /* ---- scrambler ---- */
    n2sum = 0;
    for (m = 0; m < mtbl; m++) {
        n2sum += n2tbl[m];
    }
    n2sum %= n;
    j = 0;
    for (k = 0; k < n; k++) {
        br[k] = ar[j];
        bi[k] = ai[j];
        j += n2sum;
        if (j >= n) j -= n;
    }
    /* ---- short DFTs ---- */
    for (m = 0; m < mtbl; m++) {
        n1 = n1tbl[m];
        n2 = n2tbl[m];
        for (n2t2 = n2; n2t2 < n; n2t2 += n2) {
            if (n2t2 % n1 == 1) break;
        }
        switch (n1) {
            case 2:
                length2dft(n, n2, n2t2, br, bi);
                break;
            case 3:
                length3dft(n, n2, n2t2, br, bi);
                break;
            case 4:
                length4dft(n, n2, n2t2, br, bi);
                break;
            case 5:
                length5dft(n, n2, n2t2, br, bi);
                break;
            /* case 7: */
            /* ... etc. */
            default :
                break;
        }
    }
}


void length2dft(int n, int n2, int n2t2, double ar[], double ai[])
{
    int i, j, j0, j1;
    double x0r, x0i;

    j0 = 0;
    j1 = n2t2;
    for (i = 0; i < n2; i++) {
        x0r = ar[j0] - ar[j1];
        x0i = ai[j0] - ai[j1];
        ar[j0] += ar[j1];
        ai[j0] += ai[j1];
        ar[j1] = x0r;
        ai[j1] = x0i;
        j = j1 + 1;
        j1 = j0 + 1;
        j0 = j;
    }
}


#define W3A 0.86602540378443864676  /* sin(2*pi/3) */

void length3dft(int n, int n2, int n2t2, double ar[], double ai[])
{
    int i, j, j0, j1, j2;
    double x0r, x0i, x1r, x1i, x2r, x2i;

    j0 = 0;
    j1 = n2t2;
    j2 = j1 + n2t2;
    if (j2 >= n) j2 -= n;
    for (i = 0; i < n2; i++) {
        x0r = ar[j1] + ar[j2];
        x0i = ai[j1] + ai[j2];
        x1r = W3A * (ar[j1] - ar[j2]);
        x1i = W3A * (ai[j1] - ai[j2]);
        x2r = ar[j0] - 0.5 * x0r;
        x2i = ai[j0] - 0.5 * x0i;
        ar[j0] += x0r;
        ai[j0] += x0i;
        ar[j1] = x2r + x1i;
        ai[j1] = x2i - x1r;
        ar[j2] = x2r - x1i;
        ai[j2] = x2i + x1r;
        j = j2 + 1;
        j2 = j1 + 1;
        j1 = j0 + 1;
        j0 = j;
    }
}


void length4dft(int n, int n2, int n2t2, double ar[], double ai[])
{
    int i, j, j0, j1, j2, j3;
    double x0r, x0i, x1r, x1i, x2r, x2i, x3r, x3i;

    j0 = 0;
    j1 = n2t2;
    j2 = j1 + n2t2;
    if (j2 >= n) j2 -= n;
    j3 = j2 + n2t2;
    if (j3 >= n) j3 -= n;
    for (i = 0; i < n2; i++) {
        x0r = ar[j0] + ar[j2];
        x0i = ai[j0] + ai[j2];
        x1r = ar[j0] - ar[j2];
        x1i = ai[j0] - ai[j2];
        x2r = ar[j1] + ar[j3];
        x2i = ai[j1] + ai[j3];
        x3r = ar[j1] - ar[j3];
        x3i = ai[j1] - ai[j3];
        ar[j0] = x0r + x2r;
        ai[j0] = x0i + x2i;
        ar[j2] = x0r - x2r;
        ai[j2] = x0i - x2i;
        ar[j1] = x1r + x3i;
        ai[j1] = x1i - x3r;
        ar[j3] = x1r - x3i;
        ai[j3] = x1i + x3r;
        j = j3 + 1;
        j3 = j2 + 1;
        j2 = j1 + 1;
        j1 = j0 + 1;
        j0 = j;
    }
}


#define W5A 0.55901699437494742410  /* (cos(2*pi/5)-cos(4*pi/5))/2 */
#define W5B 0.95105651629515357212  /* sin(2*pi/5) */
#define W5C 0.58778525229247312917  /* sin(4*pi/5) */

void length5dft(int n, int n2, int n2t2, double ar[], double ai[])
{
    int i, j, j0, j1, j2, j3, j4;
    double x0r, x0i, x1r, x1i, x2r, x2i, x3r, x3i, x4r, x4i;

    j0 = 0;
    j1 = n2t2;
    j2 = j1 + n2t2;
    if (j2 >= n) j2 -= n;
    j3 = j2 + n2t2;
    if (j3 >= n) j3 -= n;
    j4 = j3 + n2t2;
    if (j4 >= n) j4 -= n;
    for (i = 0; i < n2; i++) {
        x0r = ar[j1] + ar[j4];
        x0i = ai[j1] + ai[j4];
        x1r = ar[j1] - ar[j4];
        x1i = ai[j1] - ai[j4];
        x2r = ar[j2] + ar[j3];
        x2i = ai[j2] + ai[j3];
        x3r = ar[j2] - ar[j3];
        x3i = ai[j2] - ai[j3];
        x4r = W5A * (x0r - x2r);
        x4i = W5A * (x0i - x2i);
        x0r += x2r;
        x0i += x2i;
        x2r = ar[j0] - 0.25 * x0r;
        x2i = ai[j0] - 0.25 * x0i;
        ar[j0] += x0r;
        ai[j0] += x0i;
        x0r = x2r - x4r;
        x0i = x2i - x4i;
        x2r += x4r;
        x2i += x4i;
        x4r = W5B * x1r + W5C * x3r;
        x4i = W5B * x1i + W5C * x3i;
        x3r = W5C * x1r - W5B * x3r;
        x3i = W5C * x1i - W5B * x3i;
        ar[j1] = x2r + x4i;
        ai[j1] = x2i - x4r;
        ar[j4] = x2r - x4i;
        ai[j4] = x2i + x4r;
        ar[j2] = x0r + x3i;
        ai[j2] = x0i - x3r;
        ar[j3] = x0r - x3i;
        ai[j3] = x0i + x3r;
        j = j4 + 1;
        j4 = j3 + 1;
        j3 = j2 + 1;
        j2 = j1 + 1;
        j1 = j0 + 1;
        j0 = j;
    }
}

