/*
  ʣ DFT: 
      F[k]=_j=0^n-1 a[j]*exp(2*pi*i*j*k/n),0<=k<n 
  ׻.
  * ˡ
      Cooley-Tukey  FFT: 
       2, ְִ, Хե饤 1, in-place ¤ؤ
  * 
      n ϥǡ 2 , theta  2*PI/n, 
      ar[0...n-1], ai[0...n-1], ϥǡμ, .
*/
#include <math.h>

void fft(int n, double theta, double ar[], double ai[])
{
    int m, mh, i, j, k;
    double wr, wi, xr, xi;

    /* ---- scrambler ---- */
    i = 0;
    for (j = 1; j < n - 1; j++) {
        for (k = n >> 1; k > (i ^= k); k >>= 1);
        if (j < i) {
            xr = ar[j];
            xi = ai[j];
            ar[j] = ar[i];
            ai[j] = ai[i];
            ar[i] = xr;
            ai[i] = xi;
        }
    }
    theta *= n;
    for (mh = 1; (m = mh << 1) <= n; mh = m) {
        theta *= 0.5;
        for (i = 0; i < mh; i++) {
            wr = cos(theta * i);
            wi = sin(theta * i);
            for (j = i; j < n; j += m) {
                k = j + mh;
                xr = wr * ar[k] - wi * ai[k];
                xi = wr * ai[k] + wi * ar[k];
                ar[k] = ar[j] - xr;
                ai[k] = ai[j] - xi;
                ar[j] += xr;
                ai[j] += xi;
            }
        }
    }
}

