/*
  ¿ǡ DFT: 
      F[k]=_j=0^n-1 a[j]*exp(-2*pi*i*j*k/n),0<=k<n 
  ׻.
  * ˡ
      Cooley-Tukey  FFT: 
       2, ȿְ, Хե饤 1, in-place ¤ؤ
  * 
      n ϥǡ 2 , 
       a[0...n/2], a[n/2+1...n-1] Ϥ줾 F[0...n/2] μ, 
      F[n/2+1...n-1] ε롥
*/
#include <math.h>

void rfft(int n, double a[])
{
    int m, mh, mq, i, j, k, irev, jr, ji, kr, ki;
    double theta, wr, wi, xr, xi;

    /* ---- scrambler ---- */
    i = 0;
    for (j = 1; j < n - 1; j++) {
        for (k = n >> 1; k > (i ^= k); k >>= 1);
        if (j < i) {
            xr = a[j];
            a[j] = a[i];
            a[i] = xr;
        }
    }
    theta = -8 * atan(1.0) / n;
    for (mh = 1; (m = mh << 1) <= n; mh = m) {
        /* ---- real to real butterflies ---- */
        for (jr = 0; jr < n; jr += m) {
            kr = jr + mh;
            xr = a[jr] - a[kr];
            a[jr] += a[kr];
            a[kr] = xr;
        }
        if (mh == 1) continue;
        /* ---- real to complex butterflies ---- */
        mq = mh >> 1;
        irev = 0;
        for (ji = mq + m; ji < n; ji += m) {
            for (k = n >> 2; k > (irev ^= k); k >>= 1);
            wr = cos(0.5 * theta * irev);
            wi = sin(0.5 * theta * irev);
            ki = ji + mh;
            xr = a[ji];
            xi = a[ki];
            a[ji] = wr * xr + wi * xi;
            a[ki] = wr * xi - wi * xr;
        }
        if (mh == 2) continue;
        /* ---- complex to complex butterflies ---- */
        irev = 0;
        for (i = 0; i < n; i += m) {
            wr = cos(theta * irev);
            wi = sin(theta * irev);
            for (k = n >> 2; k > (irev ^= k); k >>= 1);
            for (j = 1; j < mq; j++) {
                jr = i + j;
                kr = jr + mh;
                ki = i + mh - j;
                ji = ki + mh;
                xr = a[jr] - a[kr];
                xi = a[ji] - a[ki];
                a[jr] += a[kr];
                a[ji] += a[ki];
                a[ki] = wr * xr + wi * xi;
                a[kr] = wr * xi - wi * xr;
            }
        }
    }
}

