/*
  ¿ǡ DFT: 
      F[k]=_j=0^n-1 a[j]*exp(-2*pi*i*j*k/n),0<=k<n 
  ׻.
  * ˡ
      Cooley-Tukey  FFT: 
       2, ְִ, Хե饤 2, in-place ¤ؤ
  * 
      n ϥǡ 2 , 
       a[0...n/2], a[n/2+1...n-1] Ϥ줾 F[0...n/2] μ, 
      F[n/2+1...n-1] ε롥
*/
#include <math.h>

void rfft(int n, double a[])
{
    int m, mh, mq, i, j, k, jr, ji, kr, ki;
    double theta, wr, wi, xr, xi;

    /* ---- scrambler ---- */
    i = 0;
    for (j = 1; j < n - 1; j++) {
        for (k = n >> 1; k > (i ^= k); k >>= 1);
        if (j < i) {
            xr = a[j];
            a[j] = a[i];
            a[i] = xr;
        }
    }
    theta = -8 * atan(1.0);  /* -2*pi */
    for (mh = 1; (m = mh << 1) <= n; mh = m) {
        mq = mh >> 1;
        theta *= 0.5;
        /* ---- real to real butterflies (W == 1) ---- */
        for (jr = 0; jr < n; jr += m) {
            kr = jr + mh;
            xr = a[kr];
            a[kr] = a[jr] - xr;
            a[jr] += xr;
        }
        /* ---- complex to complex butterflies (W != 1) ---- */
        for (i = 1; i < mq; i++) {
            wr = cos(theta * i);
            wi = sin(theta * i);
            for (j = 0; j < n; j += m) {
                jr = j + i;
                ji = j + mh - i;
                kr = j + mh + i;
                ki = j + m - i;
                xr = wr * a[kr] + wi * a[ki];
                xi = wr * a[ki] - wi * a[kr];
                a[kr] = -a[ji] + xi;
                a[ki] = a[ji] + xi;
                a[ji] = a[jr] - xr;
                a[jr] = a[jr] + xr;
            }
        }
        /* ---- real to complex butterflies are trivial ---- */
    }
}

