/* cubic root function in double precision */

double dcbrt(double x)
{
    int k;
    double w, y, u;
    static double c[24] = {
        0.0015319394088521, -0.018843445653409, 
        0.10170534986, -0.31702448761286, 
        0.63520892642253, -0.88106985991189, 
        1.051750376454, 0.4267412323558, 
        1.507908365919e-5, -3.7095709111375e-4, 
        0.0040043972242353, -0.024964114079723, 
        0.10003913718511, -0.27751961573273, 
        0.66256121926465, 0.53766026150315, 
        1.4842542902609e-7, -7.3027601203435e-6, 
        1.5766326109233e-4, -0.0019658008013138, 
        0.015755176844105, -0.0874132014051, 
        0.41738741349777, 0.6774094811598
    };

    if (x == 0) {
        y = 0;
        return y;
    }
    if (x > 0) {
        w = x;
        y = 0.5;
    } else {
        w = -x;
        y = -0.5;
    }
    if (w > 8) {
        while (w > 281474976710656.0) { /* 2^48 */
            w *= 3.552713678800500929355621337890625e-15; /* 2^(-48) */
            y *= 65536.0; /* 2^16 */
        }
        while (w > 8) {
            w *= 0.125;
            y *= 2;
        }
    } else if (w < 1) {
        while (w < 3.552713678800500929355621337890625e-15) {
            w *= 281474976710656.0;
            y *= 1.52587890625e-5; /* 2^(-16) */
        }
        while (w < 1) {
            w *= 8;
            y *= 0.5;
        }
    }
    if (w < 2) {
        k = 0;
    } else if (w < 4) {
        k = 8;
    } else {
        k = 16;
    }
    u = ((((((c[k] * w + c[k + 1]) * w + 
        c[k + 2]) * w + c[k + 3]) * w + 
        c[k + 4]) * w + c[k + 5]) * w + 
        c[k + 6]) * w + c[k + 7];
    y *= u + 3 * u * w / (w + 2 * u * u * u);
    return y;
}

