! Gamma/Error functions for Fortran version 2.0a
! --single-----double------quadruple---;----------defined by-----------------
!   gamma(x)   dgamma(x)   qgamma(x)   ;\int_0^\infty t^{x-1}e^{-t} dt
!   lgamma(x)  dlgamma(x)  qlgamma(x)  ;\log \Gamma(x)
!   cgamma(z)  cdgamma(z)  cqgamma(z)  ;\int_0^\infty t^{z-1}e^{-t} dt
!   clgamma(z) cdlgamma(z) cqlgamma(z) ;\log \Gamma(z)
!   erfc(x)    derfc(x)    qerfc(x)    ;2/\sqrt{\pi}\int_x^\infty e^{-t^2} dt
!   erf(x)     derf(x)     qerf(x)     ;2/\sqrt{\pi}\int_0^x e^{-t^2} dt
!   cerfc(z)   cderfc(z)   cqerfc(z)   ;2/\sqrt{\pi}\int_z^\infty e^{-t^2} dt
!   cerf(z)    cderf(z)    cqerf(z)    ;2/\sqrt{\pi}\int_0^z e^{-t^2} dt
!
      function gamma(x)
      parameter(
     &  pi= 3.14159265e+00,
     &  pv= 2.10239480e+00,
     &  pr= 3.06218544e-01,
     &  p0= 1.02416609e+00,
     &  p1= 4.25801046e-01,
     &  q1= 1.00000813e+00)
      w=x
      if(x.lt.0) w=1-x
      y=((p1/(w+q1)+p0)/w+pr)
     &  *exp((w-0.5)*log(w+pv)-w)
      if(x.lt.0) y=pi/(y*sin(pi*x))
      gamma=y
      end
!
      function lgamma(x)
      real*4 lgamma
      parameter(
     &  pi= 3.14159265e+00,
     &  pv= 2.10239480e+00,
     &  pr= 3.06218544e-01,
     &  p0= 1.02416609e+00,
     &  p1= 4.25801046e-01,
     &  q1= 1.00000813e+00)
      w=x
      if(x.lt.0) w=1-x
      y=log((p1/(w+q1)+p0)/w+pr)
     &  +(w-0.5)*log(w+pv)-w
      if(x.lt.0) y=log(pi/sin(pi*x))-y
      lgamma=y
      end
!
      function cgamma(x)
      implicit complex*8 (a-h,r-z)
      parameter(
     &  pi= 3.14159265e+00,
     &  pv= 3.18354207e+00,
     &  pr= 1.03871208e-01,
     &  p0= 7.00359329e-01,
     &  p1= 9.80795502e-01,
     &  p2= 2.06175752e-01,
     &  q1= 1.00000099e+00,
     &  q2= 1.99987038e+00)
      w=x
      if(real(x).lt.0) w=1-x
      y=(((p2/(w+q2)+p1)/(w+q1)+p0)/w+pr)
     &  *exp((w-0.5)*log(w+pv)-w)
      if(real(x).lt.0) y=pi/(y*sin(pi*x))
      cgamma=y
      end
!
      function clgamma(x)
      implicit complex*8 (a-h,t-z)
      parameter(
     &  pi= 3.14159265e+00,
     &  pv= 3.18354207e+00,
     &  pr= 1.03871208e-01,
     &  p0= 7.00359329e-01,
     &  p1= 9.80795502e-01,
     &  p2= 2.06175752e-01,
     &  q1= 1.00000099e+00,
     &  q2= 1.99987038e+00)
      w=x
      if(real(x).lt.0) w=1-x
      y=log(((p2/(w+q2)+p1)/(w+q1)+p0)/w+pr)
     &  +(w-0.5)*log(w+pv)-w
      if(real(x).lt.0) y=log(pi/sin(pi*x))-y
      r=0.5-aimag(y)/(2*pi)
      s=aint(r)-1
      clgamma=y+cmplx(0.0,(2*pi)*(aint(r-s)+s))
      end
!
      function erfc(x)
      parameter(
     &  pv= 9.20888710e+00,
     &  ph= 5.07254732e+00,
     &  p0= 3.86642217e-01,
     &  p1= 1.52430177e-01,
     &  p2= 2.38149125e-02,
     &  p3= 1.30227291e-03,
     &  q0= 1.16381965e-01,
     &  q1= 1.04753802e+00,
     &  q2= 2.92132156e+00,
     &  q3= 6.02608434e+00)
      y=x*x
      y=exp(-y)*x*(p3/(y+q3)+p2/(y+q2)
     &  +p1/(y+q1)+p0/(y+q0))
      if(x.lt.ph) y=y+2/(exp(pv*x)+1)
      erfc=y
      end
!
      function erf(x)
      parameter(
     &  p0= 1.12837916e+00,
     &  p1=-3.76122717e-01,
     &  p2= 1.12210467e-01)
      y=abs(x)
      if(y.gt.0.125) then
        erf=sign(1-erfc(y),x)
      else
        y=x*x
        erf=((p2*y+p1)*y+p0)*x
      endif
      end
!
      function cerfc(x)
      implicit complex*8 (a-h,x-z)
      parameter(
     &  pv= 9.03777677e+00,
     &  ph= 4.76888839e+00,
     &  p0= 3.92213346e-01,
     &  p1= 1.49181256e-01,
     &  p2= 2.15823157e-02,
     &  p3= 1.18760964e-03,
     &  p4= 2.48565745e-05,
     &  p5= 1.97879468e-07,
     &  q0= 1.20830487e-01)
      parameter(
     &  q1= 1.08747438e+00,
     &  q2= 3.02076217e+00,
     &  q3= 5.92069385e+00,
     &  q4= 9.78726942e+00,
     &  q5= 1.46204889e+01,
     &  r0= 2.21293361e-01,
     &  r1= 2.72957057e-01,
     &  r2= 6.40298026e-02,
     &  r3= 5.71296931e-03)
      parameter(
     &  r4= 1.93880223e-04,
     &  r5= 2.50263215e-06,
     &  r6= 1.22871857e-08,
     &  s1= 4.83321947e-01,
     &  s2= 1.93328779e+00,
     &  s3= 4.34989752e+00,
     &  s4= 7.73315115e+00,
     &  s5= 1.20830487e+01,
     &  s6= 1.73995901e+01)
      y=x*x
      if(abs(real(x))+abs(aimag(x)).lt.ph) then
        z=exp(pv*x)
        if(real(z).ge.0) then
          y=exp(-y)*x*(p5/(y+q5)+p4/(y+q4)
     &      +p3/(y+q3)+p2/(y+q2)+p1/(y+q1)
     &      +p0/(y+q0))+2/(1+z)
        else
          y=exp(-y)*x*(r6/(y+s6)+r5/(y+s5)
     &      +r4/(y+s4)+r3/(y+s3)+r2/(y+s2)
     &      +r1/(y+s1)+r0/y)+2/(1-z)
        endif
      else
        y=exp(-y)*x*(p5/(y+q5)+p4/(y+q4)
     &    +p3/(y+q3)+p2/(y+q2)+p1/(y+q1)
     &    +p0/(y+q0))
        if(real(x).lt.0) y=y+2
      endif
      cerfc=y
      end
!
      function cerf(x)
      implicit complex*8 (a-h,x-z)
      parameter(
     &  p0= 1.12837917e+00,
     &  p1=-3.76126389e-01,
     &  p2= 1.12837917e-01,
     &  p3=-2.68661706e-02)
      if(abs(real(x))+abs(aimag(x)).gt.0.125) then
        if(real(x).ge.0) then
          cerf=1-cerfc(x)
        else
          cerf=cerfc(-x)-1
        endif
      else
        y=x*x
        cerf=(((p3*y+p2)*y+p1)*y+p0)*x
      endif
      end
!
!
!
      function dgamma(x)
      implicit real*8 (a-h,o-z)
      parameter(
     &  pi= 3.14159265358979324d+00,
     &  pv= 6.09750757539068576d+00,
     &  pr= 5.63606561897560650d-03,
     &  p0= 1.22425977326879918d-01,
     &  p1= 8.51370813165034183d-01,
     &  p2= 2.25023047535618168d+00,
     &  p3= 2.09629553538949977d+00,
     &  p4= 5.02197227033920907d-01,
     &  p5= 1.12405826571654074d-02)
      parameter(
     &  q1= 1.00000000000065532d+00,
     &  q2= 1.99999999962010231d+00,
     &  q3= 3.00000004672652415d+00,
     &  q4= 3.99999663000075089d+00,
     &  q5= 5.00035898848319255d+00)
      w=x
      if(x.lt.0) w=1-x
      y=((((((p5/(w+q5)+p4)/(w+q4)+p3)/(w+q3)
     &  +p2)/(w+q2)+p1)/(w+q1)+p0)/w+pr)
     &  *exp((w-0.5d0)*log(w+pv)-w)
      if(x.lt.0) y=pi/(y*sin(pi*x))
      dgamma=y
      end
!
      function dlgamma(x)
      implicit real*8 (a-h,o-z)
      parameter(
     &  pi= 3.14159265358979324d+00,
     &  pv= 6.09750757539068576d+00,
     &  pr= 5.63606561897560650d-03,
     &  p0= 1.22425977326879918d-01,
     &  p1= 8.51370813165034183d-01,
     &  p2= 2.25023047535618168d+00,
     &  p3= 2.09629553538949977d+00,
     &  p4= 5.02197227033920907d-01,
     &  p5= 1.12405826571654074d-02)
      parameter(
     &  q1= 1.00000000000065532d+00,
     &  q2= 1.99999999962010231d+00,
     &  q3= 3.00000004672652415d+00,
     &  q4= 3.99999663000075089d+00,
     &  q5= 5.00035898848319255d+00)
      w=x
      if(x.lt.0) w=1-x
      y=log((((((p5/(w+q5)+p4)/(w+q4)+p3)/(w+q3)
     &  +p2)/(w+q2)+p1)/(w+q1)+p0)/w+pr)
     &  +(w-0.5d0)*log(w+pv)-w
      if(x.lt.0) y=log(pi/sin(pi*x))-y
      dlgamma=y
      end
!
      function cdgamma(x)
      implicit complex*16 (a-h,r-z)
      implicit real*8 (o-q)
      parameter(
     &  pi= 3.14159265358979324d+00,
     &  pv= 7.31790632447016203d+00,
     &  pr= 1.66327323256597418d-03,
     &  p0= 5.07600435957593046d-02,
     &  p1= 5.35012283109043333d-01,
     &  p2= 2.40511969085241713d+00,
     &  p3= 4.62624880633891119d+00,
     &  p4= 3.36415438064135324d+00,
     &  p5= 6.71454520397933746d-01,
     &  p6= 1.49097237136722798d-02)
      parameter(
     &  q1= 9.99999999999975753d-01,
     &  q2= 2.00000000000603851d+00,
     &  q3= 2.99999999944915534d+00,
     &  q4= 4.00000003016801681d+00,
     &  q5= 4.99999857982434025d+00,
     &  q6= 6.00009857740312429d+00)
      w=x
      if(dreal(x).lt.0) w=1-x
      y=(((((((p6/(w+q6)+p5)/(w+q5)+p4)/(w+q4)
     &  +p3)/(w+q3)+p2)/(w+q2)+p1)/(w+q1)+p0)/w+pr)
     &  *exp((w-0.5d0)*log(w+pv)-w)
      if(dreal(x).lt.0) y=pi/(y*sin(pi*x))
      cdgamma=y
      end
!
      function cdlgamma(x)
      implicit complex*16 (a-h,t-z)
      implicit real*8 (o-s)
      parameter(
     &  pi= 3.14159265358979324d+00,
     &  pv= 7.31790632447016203d+00,
     &  pr= 1.66327323256597418d-03,
     &  p0= 5.07600435957593046d-02,
     &  p1= 5.35012283109043333d-01,
     &  p2= 2.40511969085241713d+00,
     &  p3= 4.62624880633891119d+00,
     &  p4= 3.36415438064135324d+00,
     &  p5= 6.71454520397933746d-01,
     &  p6= 1.49097237136722798d-02)
      parameter(
     &  q1= 9.99999999999975753d-01,
     &  q2= 2.00000000000603851d+00,
     &  q3= 2.99999999944915534d+00,
     &  q4= 4.00000003016801681d+00,
     &  q5= 4.99999857982434025d+00,
     &  q6= 6.00009857740312429d+00)
      w=x
      if(dreal(x).lt.0) w=1-x
      y=log(((((((p6/(w+q6)+p5)/(w+q5)+p4)/(w+q4)
     &  +p3)/(w+q3)+p2)/(w+q2)+p1)/(w+q1)+p0)/w+pr)
     &  +(w-0.5d0)*log(w+pv)-w
      if(dreal(x).lt.0) y=log(pi/sin(pi*x))-y
      r=0.5d0-dimag(y)/(2*pi)
      s=dint(r)-1
      cdlgamma=y+cmplx(0.0d0,(2*pi)*(dint(r-s)+s))
      end
!
      function derfc(x)
      implicit real*8 (a-h,o-z)
      parameter(
     &  pv= 1.26974899965115684d+01,
     &  ph= 6.10399733098688199d+00,
     &  p0= 2.96316885199227378d-01,
     &  p1= 1.81581125134637070d-01,
     &  p2= 6.81866451424939493d-02,
     &  p3= 1.56907543161966709d-02,
     &  p4= 2.21290116681517573d-03,
     &  p5= 1.91395813098742864d-04,
     &  p6= 9.71013284010551623d-06,
     &  p7= 1.66642447174307753d-07)
      parameter(
     &  q0= 6.12158644495538758d-02,
     &  q1= 5.50942780056002085d-01,
     &  q2= 1.53039662058770397d+00,
     &  q3= 2.99957952311300634d+00,
     &  q4= 4.95867777128246701d+00,
     &  q5= 7.41471251099335407d+00,
     &  q6= 1.04765104356545238d+01,
     &  q7= 1.48455557345597957d+01)
      y=x*x
      y=exp(-y)*x*(p7/(y+q7)+p6/(y+q6)
     &  +p5/(y+q5)+p4/(y+q4)+p3/(y+q3)
     &  +p2/(y+q2)+p1/(y+q1)+p0/(y+q0))
      if(x.lt.ph) y=y+2/(exp(pv*x)+1)
      derfc=y
      end
!
      function derf(x)
      implicit real*8 (a-h,o-z)
      parameter(
     &  p0= 1.12837916709551257d+00,
     &  p1=-3.76126389031833602d-01,
     &  p2= 1.12837916706621301d-01,
     &  p3=-2.68661698447642378d-02,
     &  p4= 5.22387877685618101d-03,
     &  p5=-8.49202435186918470d-04)
      y=abs(x)
      if(y.gt.0.125d0) then
        derf=sign(1-derfc(y),x)
      else
        y=x*x
        derf=(((((p5*y+p4)*y+p3)*y+p2)*y+p1)*y+p0)*x
      endif
      end
!
      function cderfc(x)
      implicit complex*16 (a-h,x-z)
      implicit real*8 (o-w)
      parameter(
     &  pv= 1.27813464856668857d+01,
     &  ph= 6.64067324283344283d+00,
     &  p0= 2.94608570191793668d-01,
     &  p1= 1.81694307871527086d-01,
     &  p2= 6.91087778921425355d-02,
     &  p3= 1.62114197106901582d-02,
     &  p4= 2.34533471539159422d-03,
     &  p5= 2.09259199579049675d-04,
     &  p6= 1.15149016557480535d-05)
      parameter(
     &  p7= 3.90779571296927748d-07,
     &  p8= 8.17898509247247602d-09,
     &  p9= 1.05575446466983499d-10,
     &  p10= 8.40470321453263734d-13,
     &  p11= 4.12646136715431977d-15,
     &  p12= 1.24947948599560084d-17,
     &  q0= 6.04152433382652546d-02,
     &  q1= 5.43737190044387291d-01,
     &  q2= 1.51038108345663136d+00)
      parameter(
     &  q3= 2.96034692357499747d+00,
     &  q4= 4.89363471039948562d+00,
     &  q5= 7.31024444393009580d+00,
     &  q6= 1.02101761241668280d+01,
     &  q7= 1.35934297511096823d+01,
     &  q8= 1.74600053247586586d+01,
     &  q9= 2.18099028451137569d+01,
     &  q10= 2.66431223121749773d+01,
     &  q11= 3.19596637259423197d+01)
      parameter(
     &  q12= 3.77595270864157841d+01,
     &  r0= 1.56478036351085356d-01,
     &  r1= 2.45771407110492625d-01,
     &  r2= 1.19035163906534275d-01,
     &  r3= 3.55561834455977740d-02,
     &  r4= 6.55014550718381002d-03,
     &  r5= 7.44188068433574137d-04,
     &  r6= 5.21447276257559040d-05,
     &  r7= 2.25337799750608244d-06)
      parameter(
     &  r8= 6.00556181041662576d-08,
     &  r9= 9.87118243564461826d-10,
     &  r10= 1.00064645539515792d-11,
     &  r11= 6.25587539334288736d-14,
     &  r12= 2.41207864479170276d-16,
     &  s1= 2.41660973353061018d-01,
     &  s2= 9.66643893412244073d-01,
     &  s3= 2.17494876017754917d+00,
     &  s4= 3.86657557364897629d+00)
      parameter(
     &  s5= 6.04152433382652546d+00,
     &  s6= 8.69979504071019666d+00,
     &  s7= 1.18413876942999899d+01,
     &  s8= 1.54663022945959052d+01,
     &  s9= 1.95745388415979425d+01,
     &  s10= 2.41660973353061018d+01,
     &  s11= 2.92409777757203832d+01,
     &  s12= 3.47991801628407866d+01)
      y=x*x
      if(abs(dreal(x))+abs(dimag(x)).lt.ph) then
        z=exp(pv*x)
        if(dreal(z).ge.0) then
          y=exp(-y)*x*(p12/(y+q12)+p11/(y+q11)
     &      +p10/(y+q10)+p9/(y+q9)+p8/(y+q8)+p7/(y+q7)
     &      +p6/(y+q6)+p5/(y+q5)+p4/(y+q4)+p3/(y+q3)
     &      +p2/(y+q2)+p1/(y+q1)+p0/(y+q0))+2/(1+z)
        else
          y=exp(-y)*x*(r12/(y+s12)+r11/(y+s11)
     &      +r10/(y+s10)+r9/(y+s9)+r8/(y+s8)+r7/(y+s7)
     &      +r6/(y+s6)+r5/(y+s5)+r4/(y+s4)+r3/(y+s3)
     &      +r2/(y+s2)+r1/(y+s1)+r0/y)+2/(1-z)
        endif
      else
        y=exp(-y)*x*(p12/(y+q12)+p11/(y+q11)
     &    +p10/(y+q10)+p9/(y+q9)+p8/(y+q8)+p7/(y+q7)
     &    +p6/(y+q6)+p5/(y+q5)+p4/(y+q4)+p3/(y+q3)
     &    +p2/(y+q2)+p1/(y+q1)+p0/(y+q0))
        if(dreal(x).lt.0) y=y+2
      endif
      cderfc=y
      end
!
      function cderf(x)
      implicit complex*16 (a-h,x-z)
      implicit real*8 (o-w)
      parameter(
     &  p0= 1.12837916709551257d+00,
     &  p1=-3.76126389031837525d-01,
     &  p2= 1.12837916709551257d-01,
     &  p3=-2.68661706451312518d-02,
     &  p4= 5.22397762544218784d-03,
     &  p5=-8.54832702345085283d-04,
     &  p6= 1.20553329817896643d-04)
      if(abs(dreal(x))+abs(dimag(x)).gt.0.125d0) then
        if(dreal(x).ge.0) then
          cderf=1-cderfc(x)
        else
          cderf=cderfc(-x)-1
        endif
      else
        y=x*x
        cderf=((((((p6*y+p5)*y+p4)*y
     &        +p3)*y+p2)*y+p1)*y+p0)*x
      endif
      end
!
!
!
      function qgamma(x)
      implicit real*16 (a-h,o-z)
      parameter(
     &  pi= 3.1415926535897932384626433832795028842q+00,
     &  pv= 1.3578122000703946473976913605273518883q+01,
     &  pr= 3.1782384299734898421289539143998119380q-06,
     &  p0= 3.1482070283349300354582623623908339457q-04,
     &  p1= 1.2793741608722984500693458490473661860q-02,
     &  p2= 2.7874830306029980874434569055259616606q-01,
     &  p3= 3.5748763958228570180758258557929027134q+00,
     &  p4= 2.7927280421563325015666935178375281217q+01,
     &  p5= 1.3321384650379738989446885832268784755q+02)
      parameter(
     &  p6= 3.7950405192465422312792634449147935784q+02,
     &  p7= 6.1562149993028259463346808196235292341q+02,
     &  p8= 5.2400400869100650701118261358974985117q+02,
     &  p9= 2.0418766202023711876168179075996496480q+02,
     &  p10= 2.8645619772729108683191342647193554200q+01,
     &  p11= 8.9507210141338984737305834751291040398q-01,
     &  p12= 1.8410863315761265630602733481713520754q-03,
     &  q1= 9.9999999999999999999999999982917706744q-01,
     &  q2= 2.0000000000000000000000014372532510977q+00)
      parameter(
     &  q3= 2.9999999999999999999987806987019196983q+00,
     &  q4= 4.0000000000000000003182289605630538899q+00,
     &  q5= 4.9999999999999999603276569479688692879q+00,
     &  q6= 6.0000000000000030034309156698097129604q+00,
     &  q7= 6.9999999999998375247462698288225315906q+00,
     &  q8= 8.0000000000071915518803021765161684809q+00,
     &  q9= 8.9999999997000681861822653951282600849q+00,
     &  q10= 1.0000000014205005237309132429530491661q+01,
     &  q11= 1.0999998953920119680361242478373085334q+01,
     &  q12= 1.2000238108934194337280539725944422661q+01)
      w=x
      if(x.lt.0) w=1-x
      y=(((((((((((((p12/(w+q12)+p11)/(w+q11)
     &  +p10)/(w+q10)+p9)/(w+q9)+p8)/(w+q8)
     &  +p7)/(w+q7)+p6)/(w+q6)+p5)/(w+q5)+p4)/(w+q4)
     &  +p3)/(w+q3)+p2)/(w+q2)+p1)/(w+q1)+p0)/w+pr)
     &  *exp((w-0.5q0)*log(w+pv)-w)
      if(x.lt.0) y=pi/(y*sin(pi*x))
      qgamma=y
      end
!
      function qlgamma(x)
      implicit real*16 (a-h,o-z)
      parameter(
     &  pi= 3.1415926535897932384626433832795028842q+00,
     &  pv= 1.3578122000703946473976913605273518883q+01,
     &  pr= 3.1782384299734898421289539143998119380q-06,
     &  p0= 3.1482070283349300354582623623908339457q-04,
     &  p1= 1.2793741608722984500693458490473661860q-02,
     &  p2= 2.7874830306029980874434569055259616606q-01,
     &  p3= 3.5748763958228570180758258557929027134q+00,
     &  p4= 2.7927280421563325015666935178375281217q+01,
     &  p5= 1.3321384650379738989446885832268784755q+02)
      parameter(
     &  p6= 3.7950405192465422312792634449147935784q+02,
     &  p7= 6.1562149993028259463346808196235292341q+02,
     &  p8= 5.2400400869100650701118261358974985117q+02,
     &  p9= 2.0418766202023711876168179075996496480q+02,
     &  p10= 2.8645619772729108683191342647193554200q+01,
     &  p11= 8.9507210141338984737305834751291040398q-01,
     &  p12= 1.8410863315761265630602733481713520754q-03,
     &  q1= 9.9999999999999999999999999982917706744q-01,
     &  q2= 2.0000000000000000000000014372532510977q+00)
      parameter(
     &  q3= 2.9999999999999999999987806987019196983q+00,
     &  q4= 4.0000000000000000003182289605630538899q+00,
     &  q5= 4.9999999999999999603276569479688692879q+00,
     &  q6= 6.0000000000000030034309156698097129604q+00,
     &  q7= 6.9999999999998375247462698288225315906q+00,
     &  q8= 8.0000000000071915518803021765161684809q+00,
     &  q9= 8.9999999997000681861822653951282600849q+00,
     &  q10= 1.0000000014205005237309132429530491661q+01,
     &  q11= 1.0999998953920119680361242478373085334q+01,
     &  q12= 1.2000238108934194337280539725944422661q+01)
      w=x
      if(x.lt.0) w=1-x
      y=log(((((((((((((p12/(w+q12)+p11)/(w+q11)
     &  +p10)/(w+q10)+p9)/(w+q9)+p8)/(w+q8)
     &  +p7)/(w+q7)+p6)/(w+q6)+p5)/(w+q5)+p4)/(w+q4)
     &  +p3)/(w+q3)+p2)/(w+q2)+p1)/(w+q1)+p0)/w+pr)
     &  +(w-0.5q0)*log(w+pv)-w
      if(x.lt.0) y=log(pi/sin(pi*x))-y
      qlgamma=y
      end
!
      function cqgamma(x)
      implicit complex*32 (a-h,r-z)
      implicit real*16 (o-q)
      parameter(
     &  pi= 3.1415926535897932384626433832795028842q+00,
     &  pv= 1.7073384106072256336552635469768405988q+01,
     &  pr= 9.6430280376084227593136665415665434890q-08,
     &  p0= 1.4885966277379481312144836654780489977q-05,
     &  p1= 9.8197319346551593835492039252950643250q-04,
     &  p2= 3.6452833584596387259416230162968814334q-02,
     &  p3= 8.4440218943313053279736838769169637475q-01,
     &  p4= 1.2799395416392675659501629085367313130q+01,
     &  p5= 1.2958416314697458304456172805819466959q+02)
      parameter(
     &  p6= 8.7934757442085093139482632461747688925q+02,
     &  p7= 3.9603132208822057375892166788749852003q+03,
     &  p8= 1.1570567689267327614796506829853701257q+04,
     &  p9= 2.1118371610821741632467257070275867771q+04,
     &  p10= 2.2735240766521371105419781548988441852q+04,
     &  p11= 1.3237220278612707484073165339915814580q+04,
     &  p12= 3.6413985805433870475220843772414784920q+03,
     &  p13= 3.7799827284494982250871944924580183350q+02,
     &  p14= 9.7548265781613156543352803894655242645q+00)
      parameter(
     &  p15= 2.4781878010146311991379531059279396603q-02,
     &  q1= 9.9999999999999999999999999999999505954q-01,
     &  q2= 2.0000000000000000000000000000054314870q+00,
     &  q3= 2.9999999999999999999999999979818447021q+00,
     &  q4= 4.0000000000000000000000003832010974513q+00,
     &  q5= 4.9999999999999999999999549613824869296q+00,
     &  q6= 6.0000000000000000000036828053823278869q+00,
     &  q7= 6.9999999999999999997722128314314457093q+00,
     &  q8= 8.0000000000000000114079473554600382027q+00)
      parameter(
     &  q9= 8.9999999999999995074649343321072905406q+00,
     &  q10= 1.0000000000000019570887665497626544354q+01,
     &  q11= 1.0999999999999226781739409388855954774q+01,
     &  q12= 1.2000000000033685360735653796874490304q+01,
     &  q13= 1.2999999998107373865740824582565523337q+01,
     &  q14= 1.4000000179833580993347884693337842721q+01,
     &  q15= 1.4999950264715053014007976344403787119q+01)
      w=x
      if(qreal(x).lt.0) w=1-x
      y=((((((((((((((((p15/(w+q15)+p14)/(w+q14)
     &  +p13)/(w+q13)+p12)/(w+q12)+p11)/(w+q11)
     &  +p10)/(w+q10)+p9)/(w+q9)+p8)/(w+q8)
     &  +p7)/(w+q7)+p6)/(w+q6)+p5)/(w+q5)+p4)/(w+q4)
     &  +p3)/(w+q3)+p2)/(w+q2)+p1)/(w+q1)+p0)/w+pr)
     &  *exp((w-0.5q0)*log(w+pv)-w)
      if(qreal(x).lt.0) y=pi/(y*sin(pi*x))
      cqgamma=y
      end
!
      function cqlgamma(x)
      implicit complex*32 (a-h,t-z)
      implicit real*16 (o-s)
      parameter(
     &  pi= 3.1415926535897932384626433832795028842q+00,
     &  pv= 1.7073384106072256336552635469768405988q+01,
     &  pr= 9.6430280376084227593136665415665434890q-08,
     &  p0= 1.4885966277379481312144836654780489977q-05,
     &  p1= 9.8197319346551593835492039252950643250q-04,
     &  p2= 3.6452833584596387259416230162968814334q-02,
     &  p3= 8.4440218943313053279736838769169637475q-01,
     &  p4= 1.2799395416392675659501629085367313130q+01,
     &  p5= 1.2958416314697458304456172805819466959q+02)
      parameter(
     &  p6= 8.7934757442085093139482632461747688925q+02,
     &  p7= 3.9603132208822057375892166788749852003q+03,
     &  p8= 1.1570567689267327614796506829853701257q+04,
     &  p9= 2.1118371610821741632467257070275867771q+04,
     &  p10= 2.2735240766521371105419781548988441852q+04,
     &  p11= 1.3237220278612707484073165339915814580q+04,
     &  p12= 3.6413985805433870475220843772414784920q+03,
     &  p13= 3.7799827284494982250871944924580183350q+02,
     &  p14= 9.7548265781613156543352803894655242645q+00)
      parameter(
     &  p15= 2.4781878010146311991379531059279396603q-02,
     &  q1= 9.9999999999999999999999999999999505954q-01,
     &  q2= 2.0000000000000000000000000000054314870q+00,
     &  q3= 2.9999999999999999999999999979818447021q+00,
     &  q4= 4.0000000000000000000000003832010974513q+00,
     &  q5= 4.9999999999999999999999549613824869296q+00,
     &  q6= 6.0000000000000000000036828053823278869q+00,
     &  q7= 6.9999999999999999997722128314314457093q+00,
     &  q8= 8.0000000000000000114079473554600382027q+00)
      parameter(
     &  q9= 8.9999999999999995074649343321072905406q+00,
     &  q10= 1.0000000000000019570887665497626544354q+01,
     &  q11= 1.0999999999999226781739409388855954774q+01,
     &  q12= 1.2000000000033685360735653796874490304q+01,
     &  q13= 1.2999999998107373865740824582565523337q+01,
     &  q14= 1.4000000179833580993347884693337842721q+01,
     &  q15= 1.4999950264715053014007976344403787119q+01)
      w=x
      if(qreal(x).lt.0) w=1-x
      y=log((((((((((((((((p15/(w+q15)+p14)/(w+q14)
     &  +p13)/(w+q13)+p12)/(w+q12)+p11)/(w+q11)
     &  +p10)/(w+q10)+p9)/(w+q9)+p8)/(w+q8)
     &  +p7)/(w+q7)+p6)/(w+q6)+p5)/(w+q5)+p4)/(w+q4)
     &  +p3)/(w+q3)+p2)/(w+q2)+p1)/(w+q1)+p0)/w+pr)
     &  +(w-0.5q0)*log(w+pv)-w
      if(qreal(x).lt.0) y=log(pi/sin(pi*x))-y
      r=0.5q0-qimag(y)/(2*pi)
      s=qint(r)-1
      cqlgamma=y+cmplx(0.0q0,(2*pi)*(qint(r-s)+s))
      end
!
      function qerfc(x)
      implicit real*16 (a-h,o-z)
      parameter(
     &  pv= 1.8296570980424689847157930974106706835q+01,
     &  ph= 8.9588287394342176848213494031807385567q+00,
     &  p0= 2.1226887418241545314975570224238841543q-01,
     &  p1= 1.6766968820663231170102487414107148110q-01,
     &  p2= 1.0461429607758480243524362040994242137q-01,
     &  p3= 5.1557963860512142911764627378588661742q-02,
     &  p4= 2.0070986488528139460346647533434778000q-02,
     &  p5= 6.1717726506718148117513762897928828534q-03,
     &  p6= 1.4990611906920858646769185063310410160q-03)
      parameter(
     &  p7= 2.8760540416705806615617926157307107830q-04,
     &  p8= 4.3585593590380741491013549969419946961q-05,
     &  p9= 5.2174364856655433775383935118049845471q-06,
     &  p10= 4.9333351722974670085736982894474122277q-07,
     &  p11= 3.6846914376723888190666722894010079935q-08,
     &  p12= 2.1729515092764086499231043367920037215q-09,
     &  p13= 9.9870022842895735663712411206346261651q-11,
     &  p14= 3.1775163189596489863458236395414830880q-12,
     &  p15= 4.5657943993597540327708145643160878201q-14)
      parameter(
     &  p16= 1.1940964427370412648558173558044106203q-16,
     &  q0= 2.9482230394292049252878077330764031337q-02,
     &  q1= 2.6534007354862844327590269604581049764q-01,
     &  q2= 7.3705575985730123132195272141160572532q-01,
     &  q3= 1.4446292893203104133929687855854497896q+00,
     &  q4= 2.3880606619376559912235584857800710490q+00,
     &  q5= 3.5673498777093386979273977202889759348q+00,
     &  q6= 4.9824969366355296879760903991854492762q+00,
     &  q7= 6.6335018387405633238409855625402006223q+00)
      parameter(
     &  q8= 8.5203645862651289478197632097553870199q+00,
     &  q9= 1.0643085317662274170216548777166393329q+01,
     &  q10= 1.3001669850030489723387515813223808078q+01,
     &  q11= 1.5596282517377690399267249728222735970q+01,
     &  q12= 1.8429903207271748464995406180854691072q+01,
     &  q13= 2.1533907893494593530979123915138686107q+01,
     &  q14= 2.5076752889217226137869837117288885077q+01,
     &  q15= 2.9515380437412601845256918753602002410q+01,
     &  q16= 3.5792848810704122499184545805923520658q+01)
      y=x*x
      y=exp(-y)*x*(p16/(y+q16)+p15/(y+q15)
     &  +p14/(y+q14)+p13/(y+q13)+p12/(y+q12)
     &  +p11/(y+q11)+p10/(y+q10)+p9/(y+q9)
     &  +p8/(y+q8)+p7/(y+q7)+p6/(y+q6)
     &  +p5/(y+q5)+p4/(y+q4)+p3/(y+q3)
     &  +p2/(y+q2)+p1/(y+q1)+p0/(y+q0))
      if(x.lt.ph) y=y+2/(exp(pv*x)+1)
      qerfc=y
      end
!
      function qerf(x)
      implicit real*16 (a-h,o-z)
      parameter(
     &  p0= 1.1283791670955125738961589031215451638q+00,
     &  p1=-3.7612638903183752463205296770705954644q-01,
     &  p2= 1.1283791670955125738961588999935886077q-01,
     &  p3=-2.6866170645131251759432042514961432313q-02,
     &  p4= 5.2239776254421878419519215904293747973q-03,
     &  p5=-8.5483270234508523548393236134016747257q-04,
     &  p6= 1.2055332981788774687616425024649090688q-04,
     &  p7=-1.4925650357342418486127546759864765351q-05,
     &  p8= 1.6462113548558693746378431523719715229q-06,
     &  p9=-1.6365454692461428822012524459668520250q-07,
     &  p10= 1.4701966650809284594534032908988195691q-08)
      y=abs(x)
      if(y.gt.0.125q0) then
        qerf=sign(1-qerfc(y),x)
      else
        y=x*x
        qerf=((((((((((p10*y+p9)*y+p8)*y+p7)*y+p6)*y
     &       +p5)*y+p4)*y+p3)*y+p2)*y+p1)*y+p0)*x
      endif
      end
!
      function cqerfc(x)
      implicit complex*32 (a-h,x-z)
      implicit real*16 (o-w)
      parameter(
     &  pv= 1.8419880743036792792631929248006767493q+01,
     &  ph= 9.4599403715183963963159646240033837464q+00,
     &  p0= 2.1093083061644187538279122968913808152q-01,
     &  p1= 1.6713797949733065528971052035163045322q-01,
     &  p2= 1.0494102880451803704489103456267864462q-01,
     &  p3= 5.2209624806229062497556308453704817574q-02,
     &  p4= 2.0582158194044619069754225289969978299q-02,
     &  p5= 6.4293391618431334949721030322694803569q-03,
     &  p6= 1.5913908100149480106505036886507485785q-03)
      parameter(
     &  p7= 3.1212060500464898607481297780989148689q-04,
     &  p8= 4.8506855193831619356742051276480109919q-05,
     &  p9= 5.9733626677651815061875193953000538326q-06,
     &  p10= 5.8286735523223186734841193923199386322q-07,
     &  p11= 4.5066690471880700341073630648957059945q-08,
     &  p12= 2.7610653454261808871589140980422088532q-09,
     &  p13= 1.3403949680961254958324655659147790094q-10,
     &  p14= 5.1561314110869289752886735305964573946q-12,
     &  p15= 1.5716297853674992841622413214543994197q-13)
      parameter(
     &  p16= 3.7958724379391814374198930599398267061q-15,
     &  p17= 7.2645388829894728683842661597496303959q-17,
     &  p18= 1.1016397065175311063529497475707242525q-18,
     &  p19= 1.3237506731591609005566634525737840832q-20,
     &  p20= 1.2603985415835627864680027724651354389q-22,
     &  p21= 9.5092151781247278003169665785149729821q-25,
     &  p22= 5.6848177046496801634666761604409403206q-27,
     &  p23= 2.6929202705338711046737832028758053393q-29,
     &  p24= 1.0108006977320702265677957534508423789q-31)
      parameter(
     &  p25= 3.0063715680065086923565072577882673057q-34,
     &  p26= 7.0852448481490904907112832127691803349q-37,
     &  q0= 2.9088820866572159615394846141476878557q-02,
     &  q1= 2.6179938779914943653855361527329190702q-01,
     &  q2= 7.2722052166430399038487115353692196393q-01,
     &  q3= 1.4253522224620358211543474609323670493q+00,
     &  q4= 2.3561944901923449288469825374596271631q+00,
     &  q5= 3.5197473248552313134627763831187023054q+00,
     &  q6= 4.9160107264506949750017289979095924762q+00)
      parameter(
     &  q7= 6.5449846949787359134638403818322976754q+00,
     &  q8= 8.4066692304393541288491105348868179031q+00,
     &  q9= 1.0501064332832549621157539457073153159q+01,
     &  q10= 1.2828170002158322390389127148391303444q+01,
     &  q11= 1.5387986238416672436543873608841268757q+01,
     &  q12= 1.8180513041607599759621778838423049098q+01,
     &  q13= 2.1205750411731104359622842837136644468q+01,
     &  q14= 2.4463698348787186236547065604982054867q+01,
     &  q15= 2.7954356852775845390394447141959280294q+01)
      parameter(
     &  q16= 3.1677725923697081821164987448068320749q+01,
     &  q17= 3.5633805561550895528858686523309176233q+01,
     &  q18= 3.9822595766337286513475544367681846745q+01,
     &  q19= 4.4244096538056254775015560981186332286q+01,
     &  q20= 4.8898307876707800313478736363822632855q+01,
     &  q21= 5.3785229782291923128865070515590748453q+01,
     &  q22= 5.8904862254808623221174563436490679079q+01,
     &  q23= 6.4257205294257900590407215126522424733q+01,
     &  q24= 6.9842258900639755236563025585685985416q+01)
      parameter(
     &  q25= 7.5660023073954187159641994813981361128q+01,
     &  q26= 8.1710497814201196359644122811408551868q+01,
     &  r0= 1.0857833597842664924141880507518822324q-01,
     &  r1= 1.9330394605384376865851659517702988226q-01,
     &  r2= 1.3634629684679999083131393208557974008q-01,
     &  r3= 7.6204577450604403788088248675471849578q-02,
     &  r4= 3.3748451951221171387030636574487677141q-02,
     &  r5= 1.1843000251292400843913857684704052043q-02,
     &  r6= 3.2930983812757205929921213829383580821q-03)
      parameter(
     &  r7= 7.2557574646222760967368809292892366817q-04,
     &  r8= 1.2667645289367856821531300675005701424q-04,
     &  r9= 1.7524438664090954799894562703988992670q-05,
     &  r10= 1.9210002539217758384351411001702958461q-06,
     &  r11= 1.6685753127194156512431242433234203465q-07,
     &  r12= 1.1484161468186100454021914187739990566q-08,
     &  r13= 6.2630784459909945721312231747915945961q-10,
     &  r14= 2.7065216004464856039123247342635784082q-11,
     &  r15= 9.2676629018209927646524369276088075961q-13)
      parameter(
     &  r16= 2.5145718215575387941885792873856026053q-14,
     &  r17= 5.4062104214337911880413049229210178595q-16,
     &  r18= 9.2099427616964263777001122276945386232q-18,
     &  r19= 1.2432429403206980797482152563988923532q-19,
     &  r20= 1.3298117235769445146920469835700830835q-21,
     &  r21= 1.1270920794418483512403852639398106151q-23,
     &  r22= 7.5694395178532891627960685040600391752q-26,
     &  r23= 4.0281268032076992671072314251173518774q-28,
     &  r24= 1.6985472346741765564942981815307583270q-30)
      parameter(
     &  r25= 5.6752788970027027984246568768226680280q-33,
     &  r26= 1.5025601745064174185565587049015131885q-35,
     &  s1= 1.1635528346628863846157938456590751423q-01,
     &  s2= 4.6542113386515455384631753826363005692q-01,
     &  s3= 1.0471975511965977461542144610931676281q+00,
     &  s4= 1.8616845354606182153852701530545202277q+00,
     &  s5= 2.9088820866572159615394846141476878557q+00,
     &  s6= 4.1887902047863909846168578443726705123q+00,
     &  s7= 5.7014088898481432846173898437294681972q+00)
      parameter(
     &  s8= 7.4467381418424728615410806122180809107q+00,
     &  s9= 9.4247779607693797153879301498385086526q+00,
     &  s10= 1.1635528346628863846157938456590751423q+01,
     &  s11= 1.4078989299420925253851105532474809222q+01,
     &  s12= 1.6755160819145563938467431377490682049q+01,
     &  s13= 1.9664042905802779900006915991638369905q+01,
     &  s14= 2.2805635559392573138469559374917872789q+01,
     &  s15= 2.6179938779914943653855361527329190702q+01,
     &  s16= 2.9786952567369891446164322448872323643q+01)
      parameter(
     &  s17= 3.3626676921757416515396442139547271612q+01,
     &  s18= 3.7699111843077518861551720599354034610q+01,
     &  s19= 4.2004257331330198484630157828292612637q+01,
     &  s20= 4.6542113386515455384631753826363005692q+01,
     &  s21= 5.1312680008633289561556508593565213775q+01,
     &  s22= 5.6315957197683701015404422129899236887q+01,
     &  s23= 6.1551944953666689746175494435365075027q+01,
     &  s24= 6.7020643276582255753869725509962728196q+01,
     &  s25= 7.2722052166430399038487115353692196393q+01,
     &  s26= 7.8656171623211119600027663966553479619q+01)
      y=x*x
      if(abs(qreal(x))+abs(qimag(x)).lt.ph) then
        z=exp(pv*x)
        if(qreal(z).ge.0) then
          y=exp(-y)*x*(p26/(y+q26)
     &      +p25/(y+q25)+p24/(y+q24)+p23/(y+q23)
     &      +p22/(y+q22)+p21/(y+q21)+p20/(y+q20)
     &      +p19/(y+q19)+p18/(y+q18)+p17/(y+q17)
     &      +p16/(y+q16)+p15/(y+q15)+p14/(y+q14)
     &      +p13/(y+q13)+p12/(y+q12)+p11/(y+q11)
     &      +p10/(y+q10)+p9/(y+q9)+p8/(y+q8)+p7/(y+q7)
     &      +p6/(y+q6)+p5/(y+q5)+p4/(y+q4)+p3/(y+q3)
     &      +p2/(y+q2)+p1/(y+q1)+p0/(y+q0))+2/(1+z)
        else
          y=exp(-y)*x*(r26/(y+s26)
     &      +r25/(y+s25)+r24/(y+s24)+r23/(y+s23)
     &      +r22/(y+s22)+r21/(y+s21)+r20/(y+s20)
     &      +r19/(y+s19)+r18/(y+s18)+r17/(y+s17)
     &      +r16/(y+s16)+r15/(y+s15)+r14/(y+s14)
     &      +r13/(y+s13)+r12/(y+s12)+r11/(y+s11)
     &      +r10/(y+s10)+r9/(y+s9)+r8/(y+s8)+r7/(y+s7)
     &      +r6/(y+s6)+r5/(y+s5)+r4/(y+s4)+r3/(y+s3)
     &      +r2/(y+s2)+r1/(y+s1)+r0/y)+2/(1-z)
        endif
      else
        y=exp(-y)*x*(p26/(y+q26)
     &    +p25/(y+q25)+p24/(y+q24)+p23/(y+q23)
     &    +p22/(y+q22)+p21/(y+q21)+p20/(y+q20)
     &    +p19/(y+q19)+p18/(y+q18)+p17/(y+q17)
     &    +p16/(y+q16)+p15/(y+q15)+p14/(y+q14)
     &    +p13/(y+q13)+p12/(y+q12)+p11/(y+q11)
     &    +p10/(y+q10)+p9/(y+q9)+p8/(y+q8)+p7/(y+q7)
     &    +p6/(y+q6)+p5/(y+q5)+p4/(y+q4)+p3/(y+q3)
     &    +p2/(y+q2)+p1/(y+q1)+p0/(y+q0))
        if(qreal(x).lt.0) y=y+2
      endif
      cqerfc=y
      end
!
      function cqerf(x)
      implicit complex*32 (a-h,x-z)
      implicit real*16 (o-w)
      parameter(
     &  p0= 1.1283791670955125738961589031215451717q+00,
     &  p1=-3.7612638903183752463205296770718172390q-01,
     &  p2= 1.1283791670955125738961589031215451717q-01,
     &  p3=-2.6866170645131251759432354836227265993q-02,
     &  p4= 5.2239776254421878421118467737108572763q-03,
     &  p5=-8.5483270234508528325466583569814028158q-04,
     &  p6= 1.2055332981789664251027338708563516792q-04,
     &  p7=-1.4925650358406250977462419353459592218q-05,
     &  p8= 1.6462114365889247401612962522198079652q-06)
      parameter(
     &  p9=-1.6365844691234924317393003677039026555q-07,
     &  p10= 1.4807192815879217239546050945892452597q-08,
     &  p11=-1.2290555301717927352982888136906778836q-09,
     &  p12= 9.4227590646504109706202142382951971074q-11,
     &  p13=-6.7113668551641103779346255258512799910q-12)
      if(abs(qreal(x))+abs(qimag(x)).gt.0.125q0) then
        if(qreal(x).ge.0) then
          cqerf=1-cqerfc(x)
        else
          cqerf=cqerfc(-x)-1
        endif
      else
        y=x*x
        cqerf=(((((((((((((p13*y+p12)*y+p11)*y+p10)*y
     &        +p9)*y+p8)*y+p7)*y+p6)*y+p5)*y+p4)*y
     &        +p3)*y+p2)*y+p1)*y+p0)*x
      endif
      end
!
