!     test of chebexp.f
!
      include 'chebexp.f'
      include 'fft2f.f'
!
      program main
      implicit real*8 (a - i, o - z)
      parameter (lenc = 1024 + 4)
      dimension c(0 : lenc)
      common / nf / n
      external f
      n = 0
      a = 1.0d0
      b = 2.0d0
      eps = 1.0d-14
      call chebexp(f, a, b, eps, lenc, c, err)
      nn = n
      emax = 0
      do j = 0, nn
          x = a + (b - a) * j / nn
          e = chebeval(x, c) - f(x)
          emax = max(emax, abs(e))
      end do
      write (*, *) 'interpolation of sin(log(x)) over [', a, ',', 
     &    b, ']'
      write (*, *) 'N_eval=', nn, '  n=', int(c(1)), '  err=', err, 
     &    '  max_err=', emax
      end
!
!
      function f(x)
      implicit real*8 (a - i, o - z)
      common / nf / n
      n = n + 1
      f = sin(log(x))
      end
!
