! Clenshaw-Curtis-Quadrature
! Numerical Automatic Integrator
!     method    : Chebyshev Series Expansion
!     dimension : one
!     table     : not use
! subroutine
!     intcc  : integrator of f(x) over [a,b].
! necessary package
!     fft2f.f  : FFT package
!
!
! intcc
!     [description]
!         I = integral of f(x) over [a,b]
!     [declaration]
!         external f
!     [usage]
!         call intcc(f, a, b, eps, lenc, c, i, err)
!     [parameters]
!         f         : integrand f(x) (real*8 function)
!         a         : lower limit of integration (real*8)
!         b         : upper limit of integration (real*8)
!         eps       : relative error requested (real*8)
!         lenc      : (length of c()) - 1 (integer)
!         c         : work area for Chebyshev expansion, 
!                     c(0...lenc) (real*8)
!         i         : approximation to the integral (real*8)
!         err       : estimate of the absolute error (real*8)
!     [remarks]
!         initial parameters
!             lenc >= 8 and 
!             lenc > (maximum number of f(x) evaluations) / 2
!             example :
!                 lenc = 1024
!         function
!             f(x) needs to be analytic over [a,b].
!         relative error
!             eps is relative error requested excluding 
!             cancellation of significant digits.
!             i.e. eps means : (absolute error) / 
!                              (integral_a^b |f(x)| dx).
!             eps does not mean : (absolute error) / I.
!         error message
!             err >= 0 : normal termination.
!             err < 0  : abnormal termination (n > nmax).
!                        i.e. convergent error is detected :
!                            1. f(x) or (d/dx)^n f(x) has 
!                               discontinuous points or sharp 
!                               peaks over [a,b].
!                               you must use other routine.
!                            2. relative error of f(x) is 
!                               greater than eps.
!                            3. f(x) has oscillatory factor 
!                               and frequency of the oscillation 
!                               is very high.
!
!
      subroutine intcc(f, a, b, eps, lenc, c, i, err)
      integer lenc
      real*8 c(0 : lenc), f, a, b, i, eps, err
      integer j, k, l, n
      real*8 eref, t0, t1, ba, cos2, sin2, wi, ss, x, y
      ba = 0.5d0 * (b - a)
      cos2 = 2 + sqrt(2.0d0)
      sin2 = 1 / cos2
      x = ba * sin2
      c(0) = 0.5d0 * f(a)
      c(1) = 0.5d0 * f(b)
      c(2) = f(a + ba)
      c(3) = f(a + x)
      c(4) = f(b - x)
      eref = eps * (abs(c(0)) + abs(c(1)) + abs(c(2)) + abs(c(3)) + 
     &    abs(c(4)))
      t0 = c(0) + c(1)
      t1 = c(3) + c(4)
      c(lenc - 1) = t0 - c(2)
      t0 = t0 + c(2)
      c(lenc - 2) = t0 - t1
      c(lenc) = t0 + t1
      wi = -1
      l = 2
      n = 4
   10 continue
          ss = 2 * sin2
          cos2 = 2 + sqrt(cos2)
          sin2 = sin2 / cos2
          x = ba * sin2
          y = 0
          do j = 0, l - 1
              x = x + y
              y = y + ss * (ba - x)
              c(j) = f(a + x) + f(b - x)
          end do
          wi = wi / (2 - ss)
          call ddct(l, 0.5d0 * (2 - ss), wi, c)
          do j = l - 1, 0, -1
              k = lenc - j
              t1 = c(k) - c(j)
              c(k) = c(k) + c(j)
              c(lenc - n + j) = t1
          end do
          err = abs(c(lenc - n)) + abs(c(lenc - n + 1))
          eref = eref * 2
          l = n
          n = n * 2
      if (err .gt. eref * n .and. n .le. lenc) goto 10
      c(lenc) = c(lenc) * 0.5d0
      c(lenc - l) = c(lenc - l) * 0.5d0
      i = 0
      do j = l, 0, -1
          i = i + c(lenc - j) / (1 - 4 * j * j)
      end do
      i = i * (b - a) / l
      if (err .gt. eref * n) then
          err = -err * abs((b - a) / l)
      else
          err = eref * abs((b - a) / l)
      end if
      end
!
